/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.jep.util;

import java.io.IOException;
import java.io.StringReader;
import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtils {
    private XmlUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static XPathExpression compileXPath(String expression) throws XPathExpressionException {
        return XPathFactory.newInstance().newXPath().compile(expression);
    }

    public static NodeList evaluateXPath(Document xmlDocument, String expression) throws XPathExpressionException {
        return (NodeList)XmlUtils.compileXPath(expression).evaluate(xmlDocument, XPathConstants.NODESET);
    }

    public static NodeList evaluateXPath(String xmlContent, String expression) throws XPathExpressionException, ParserConfigurationException, SAXException, IOException {
        Document xmlDocument = XmlUtils.convertToXML(xmlContent);
        return XmlUtils.evaluateXPath(xmlDocument, expression);
    }

    public static List<Object> evaluateXPathAsObjectList(Document xmlDocument, String expression) throws XPathExpressionException {
        return XmlUtils.asList(XmlUtils.evaluateXPath(xmlDocument, expression));
    }

    public static List<Object> evaluateXPathAsObjectList(String xmlContent, String expression) throws XPathExpressionException, ParserConfigurationException, SAXException, IOException {
        return XmlUtils.asList(XmlUtils.evaluateXPath(xmlContent, expression));
    }

    public static List<Object> asList(NodeList n) {
        return n.getLength() == 0 ? Collections.emptyList() : new NodeListWrapper(n);
    }

    public static Document convertToXML(Object object) throws ParserConfigurationException, SAXException, IOException {
        if (object instanceof Document) {
            return (Document)object;
        }
        if (object instanceof String) {
            return XmlUtils.convertToXML((String)object);
        }
        throw new IllegalArgumentException("Input type " + object.getClass().getName() + " not supported as XML");
    }

    public static Document convertToXML(String xmlContent) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        return builder.parse(new InputSource(new StringReader(xmlContent)));
    }

    private static final class NodeListWrapper
    extends AbstractList<Object>
    implements RandomAccess {
        private final NodeList list;

        NodeListWrapper(NodeList list) {
            this.list = list;
        }

        @Override
        public Object get(int index) {
            Node node = this.list.item(index);
            return node.getNodeValue();
        }

        @Override
        public int size() {
            return this.list.getLength();
        }
    }
}

