/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.jep.util;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JsonOrgJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonUtils {
    private static final Configuration JSON_PATH_CONFIGURATION = Configuration.builder().jsonProvider((JsonProvider)new JsonOrgJsonProvider()).build();

    private JsonUtils() {
        throw new IllegalStateException("Utility class");
    }

    private static boolean isEmpty(JSONObject jsonObject) {
        return jsonObject == null || jsonObject.length() == 0;
    }

    private static boolean isEmpty(JSONArray jsonArray) {
        return jsonArray == null || jsonArray.length() == 0;
    }

    public static boolean isEmpty(Object object) {
        if (object instanceof JSONObject) {
            return JsonUtils.isEmpty((JSONObject)object);
        }
        if (object instanceof JSONArray) {
            return JsonUtils.isEmpty((JSONArray)object);
        }
        return object == null || JSONObject.NULL.equals(object);
    }

    public static JsonPath compileJsonPath(String jsonPath) {
        return JsonPath.compile((String)jsonPath, (Predicate[])new Predicate[0]);
    }

    public static Object readJsonPath(JSONObject json, String jsonPath) {
        if (JsonUtils.isEmpty(json)) {
            return json;
        }
        return JsonPath.parse((Object)json, (Configuration)JSON_PATH_CONFIGURATION).read(jsonPath, new Predicate[0]);
    }

    public static Object readJsonPath(JSONObject json, String jsonPath, boolean extractSingleElement) {
        Object evaluationResult = JsonUtils.readJsonPath(json, jsonPath);
        if (extractSingleElement) {
            return JsonUtils.getSingleValueFromJSONArray(evaluationResult);
        }
        return evaluationResult;
    }

    protected static Object getSingleValueFromJSONArray(Object evaluationResult) {
        JSONArray pJSONArray;
        if (evaluationResult instanceof JSONArray && (pJSONArray = (JSONArray)evaluationResult).length() == 1) {
            return pJSONArray.opt(0);
        }
        return evaluationResult;
    }

    public static JSONObject toJSONObject(Object object) throws JSONException {
        if (object == null) {
            return new JSONObject();
        }
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        return new JSONObject(object.toString());
    }

    public static JSONArray toJSONArray(Object object) throws JSONException {
        if (object == null) {
            return new JSONArray();
        }
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        return new JSONArray(object.toString());
    }

    public static List<Object> toList(JSONArray jsonArray) {
        try {
            if (JsonUtils.isEmpty(jsonArray)) {
                return Collections.emptyList();
            }
            ArrayList<Object> list = new ArrayList<Object>(jsonArray.length());
            int length = jsonArray.length();
            for (int i = 0; i < length; ++i) {
                if (JsonUtils.isEmpty(jsonArray.get(i))) {
                    list.add(null);
                    continue;
                }
                list.add(jsonArray.get(i));
            }
            return list;
        }
        catch (JSONException exception) {
            throw new IllegalStateException(exception);
        }
    }
}

