/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.jep.util;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

public class EncryptionUtils {
    private EncryptionUtils() {
        throw new IllegalStateException("Utility class");
    }

    private static String bytesToHex(byte[] array) {
        StringBuilder hexString = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            hexString.append(Integer.toHexString(array[i] & 0xFF | 0x100).substring(1, 3));
        }
        return hexString.toString();
    }

    public static String hashWith(String algorithm, String content) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
            byte[] encodedHash = messageDigest.digest(content.getBytes(StandardCharsets.UTF_8));
            return EncryptionUtils.bytesToHex(encodedHash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String sha256(String content) {
        return EncryptionUtils.hashWith("SHA-256", content);
    }

    public static String toBase64(String content) {
        return Base64.getEncoder().encodeToString(content.getBytes(StandardCharsets.UTF_8));
    }

    public static String fromBase64(String content) {
        return new String(Base64.getDecoder().decode(content), StandardCharsets.UTF_8);
    }
}

