/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.jep.util;

import java.text.ParseException;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.DateFormatUtils;

public class DateUtils {
    private static final String[] ISO_8601_COMMON_PATTERNS = new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSSXXX", "yyyy-MM-dd'T'HH:mm:ss.SSSXX", "yyyy-MM-dd'T'HH:mm:ss.SSSX", "yyyy-MM-dd'T'HH:mm:ssXXX", "yyyy-MM-dd'T'HH:mm:ssXX", "yyyy-MM-dd'T'HH:mm:ssX", "yyyy-MM-dd'T'K:mm:ss a, z", "yyyy-MM-dd HH:mm:ss.SSSXXX", "yyyy-MM-dd HH:mm:ss.SSSXX", "yyyy-MM-dd HH:mm:ss.SSSX", "yyyy-MM-dd HH:mm:ssXXX", "yyyy-MM-dd HH:mm:ssXX", "yyyy-MM-dd HH:mm:ssX", "yyyy-MM-dd'T'K:mm:ss.SSS a, z", "yyyy-MM-dd'T'K:mm:ss a, z", "yyyy-MM-dd K:mm:ss a, z", "yyyy-MM-dd K:mm:ss.SSS a, z", "yyyy-MM-dd"};

    private DateUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static String formatDate(Date date, String pattern) {
        return DateFormatUtils.format((Date)date, (String)pattern);
    }

    public static Date parseDate(String string, String ... patterns) throws ParseException {
        return org.apache.commons.lang3.time.DateUtils.parseDate((String)string, (String[])patterns);
    }

    public static Date parseDateRfc3339(String string) {
        try {
            Instant instant = Instant.parse(string);
            return Date.from(instant);
        }
        catch (DateTimeParseException cause) {
            throw new IllegalArgumentException(cause);
        }
    }

    public static Date parseDateIso8601(String string) {
        try {
            return org.apache.commons.lang3.time.DateUtils.parseDate((String)string, (String[])ISO_8601_COMMON_PATTERNS);
        }
        catch (ParseException cause) {
            throw new IllegalArgumentException(cause);
        }
    }

    public static Date parseDate(Object object) {
        if (object instanceof Date) {
            return (Date)object;
        }
        if (object instanceof Instant) {
            return Date.from((Instant)object);
        }
        String strDate = String.valueOf(object);
        try {
            return DateUtils.parseDateRfc3339(strDate);
        }
        catch (IllegalArgumentException exception) {
            return DateUtils.parseDateIso8601(strDate);
        }
    }

    public static boolean isParsable(Object object) {
        if (object instanceof Date || object instanceof Instant) {
            return true;
        }
        String string = String.valueOf(object);
        return DateUtils.isParsableRfc3339(string) || DateUtils.isParsableIso8601(string);
    }

    public static boolean isParsableRfc3339(String string) {
        try {
            DateUtils.parseDateRfc3339(string);
            return true;
        }
        catch (IllegalArgumentException exception) {
            return false;
        }
    }

    public static boolean isParsableIso8601(String string) {
        try {
            DateUtils.parseDateIso8601(string);
            return true;
        }
        catch (IllegalArgumentException exception) {
            return false;
        }
    }

    public static boolean containsParsableDates(Iterable<?> iterable) {
        Iterator<?> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            if (DateUtils.isParsable(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean containsParsableDatesRfc3339(Iterable<?> iterable) {
        for (Object element : iterable) {
            if (DateUtils.isParsableRfc3339(String.valueOf(element))) continue;
            return false;
        }
        return true;
    }

    public static boolean containsParsableDatesIso8601(Iterable<?> iterable) {
        for (Object element : iterable) {
            if (DateUtils.isParsableIso8601(String.valueOf(element))) continue;
            return false;
        }
        return true;
    }

    public static Calendar toCalendar(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("Date cannot be null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static long daysBetween(Date firstDate, Date secondDate) {
        if (firstDate == null) {
            throw new IllegalArgumentException("First date cannot be null");
        }
        if (secondDate == null) {
            throw new IllegalArgumentException("Second date cannot be null");
        }
        long differenceInMillis = Math.abs(firstDate.getTime() - secondDate.getTime());
        return TimeUnit.DAYS.convert(differenceInMillis, TimeUnit.MILLISECONDS);
    }

    public static boolean isLeapYear(Date date) {
        Calendar calendar = DateUtils.toCalendar(date);
        return DateUtils.isLeapYear(calendar.get(1));
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    public static int getIsoWeekNumber(Date date) {
        Calendar calendar = DateUtils.toCalendar(date);
        calendar.setMinimalDaysInFirstWeek(4);
        calendar.setFirstDayOfWeek(2);
        return calendar.get(3);
    }

    public static int getMonth(Date date) {
        Calendar calendar = DateUtils.toCalendar(date);
        return calendar.get(2) + 1;
    }

    public static int getQuarter(Date date) {
        Calendar calendar = DateUtils.toCalendar(date);
        return calendar.get(2) / 3 + 1;
    }

    public static int getDateField(Date date, int calendarCode) {
        Calendar calendar = DateUtils.toCalendar(date);
        return calendar.get(calendarCode);
    }

    public static Date endOfMonth(Date date) {
        Calendar calendar = DateUtils.toCalendar(date);
        calendar.set(5, calendar.getActualMaximum(5));
        calendar.set(11, calendar.getActualMaximum(11));
        calendar.set(12, calendar.getActualMaximum(12));
        calendar.set(13, calendar.getActualMaximum(13));
        calendar.set(14, calendar.getActualMaximum(14));
        return calendar.getTime();
    }
}

