/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.jep.http;

import javax.ws.rs.core.Response;

public class WebServiceResponse {
    private final int statusCode;
    private final String statusDescription;
    private final String body;

    public WebServiceResponse(int statusCode, String statusDescription, String body) {
        this.statusCode = statusCode;
        this.statusDescription = statusDescription;
        this.body = body;
    }

    public static WebServiceResponse fromClientResponse(Response response) {
        return new WebServiceResponse(response.getStatus(), response.getStatusInfo().getReasonPhrase(), (String)response.readEntity(String.class));
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusDescription() {
        return this.statusDescription;
    }

    public String getBody() {
        return this.body;
    }

    public boolean isSuccessful() {
        return Response.Status.Family.SUCCESSFUL == Response.Status.fromStatusCode((int)this.statusCode).getFamily();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("WebServiceResponse: ").append(this.statusCode).append(" (").append(this.statusDescription).append(")");
        return sb.toString();
    }
}

