/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.jep.functions;

import java.util.Stack;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.obvj.jep.functions.MultiStrategyCommand;
import org.apache.commons.text.CaseUtils;
import org.apache.commons.text.WordUtils;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class UnaryStringFunction
extends PostfixMathCommand
implements MultiStrategyCommand {
    protected static final char[] SEPARATORS = new char[]{' ', '_', '-'};
    private final Strategy strategy;

    public UnaryStringFunction(Strategy strategy) {
        this.numberOfParameters = 1;
        this.strategy = strategy;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object param = stack.pop();
        String result = param == null ? null : this.strategy.apply(param.toString());
        stack.push(result);
    }

    @Override
    public Object getStrategy() {
        return this.strategy;
    }

    public static enum Strategy implements UnaryOperator<String>
    {
        CAMEL(param -> CaseUtils.toCamelCase((String)param, (boolean)false, (char[])SEPARATORS)),
        LOWER(param -> param.toLowerCase()),
        PROPER(WordUtils::capitalizeFully),
        TRIM(param -> param.trim()),
        UPPER(param -> param.toUpperCase());

        Function<String, String> function;

        private Strategy(UnaryOperator<String> function) {
            this.function = function;
        }

        @Override
        public String apply(String string) {
            return this.function.apply(string);
        }
    }
}

