/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.jep.functions;

import java.util.Date;
import java.util.Stack;
import net.obvj.jep.functions.Function;
import net.obvj.jep.util.DateUtils;
import org.apache.commons.lang3.StringUtils;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

@Function(value={"str2date"})
public class StringToDate
extends PostfixMathCommand {
    public StringToDate() {
        this.numberOfParameters = -1;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        if (this.curNumberOfParameters < 1) {
            throw new ParseException("At least one string is required");
        }
        int numberOfPatterns = this.curNumberOfParameters - 1;
        String[] patterns = new String[numberOfPatterns];
        for (int i = numberOfPatterns - 1; i >= 0; --i) {
            patterns[i] = String.valueOf(stack.pop());
        }
        Object date = stack.pop();
        this.validateInput(date);
        stack.push(this.parseDate(String.valueOf(date), patterns));
    }

    private void validateInput(Object source) {
        if (source == null || StringUtils.isEmpty((CharSequence)source.toString())) {
            throw new IllegalArgumentException(String.format("Invalid parameter received: (%s)", source));
        }
    }

    private Date parseDate(String date, String[] patterns) {
        try {
            return patterns.length == 0 ? DateUtils.parseDate(date) : DateUtils.parseDate(date, patterns);
        }
        catch (java.text.ParseException parseException) {
            throw new IllegalArgumentException(parseException);
        }
    }
}

