/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.jep.functions;

import java.util.Date;
import java.util.Stack;
import java.util.function.ToIntFunction;
import net.obvj.jep.functions.MultiStrategyCommand;
import net.obvj.jep.util.DateUtils;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class DateFieldGetter
extends PostfixMathCommand
implements MultiStrategyCommand {
    private final DateField dateField;

    public DateFieldGetter(DateField dateField) {
        this.numberOfParameters = 1;
        this.dateField = dateField;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object parameter = stack.pop();
        Date date = DateUtils.parseDate(parameter);
        stack.push(this.dateField.getFromDate(date));
    }

    @Override
    public Object getStrategy() {
        return this.dateField;
    }

    public static enum DateField {
        YEAR(date -> DateUtils.getDateField(date, 1)),
        QUARTER(DateUtils::getQuarter),
        MONTH(DateUtils::getMonth),
        ISO_WEEK_NUMBER(DateUtils::getIsoWeekNumber),
        WEEK_DAY(date -> DateUtils.getDateField(date, 7)),
        DAY(date -> DateUtils.getDateField(date, 5)),
        HOUR(date -> DateUtils.getDateField(date, 11)),
        MINUTE(date -> DateUtils.getDateField(date, 12)),
        SECOND(date -> DateUtils.getDateField(date, 13)),
        MILLISECOND(date -> DateUtils.getDateField(date, 14));

        private ToIntFunction<Date> function;

        private DateField(ToIntFunction<Date> function) {
            this.function = function;
        }

        int getFromDate(Date date) {
            return this.function.applyAsInt(date);
        }
    }
}

