/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.jep.functions;

import java.util.Date;
import java.util.Stack;
import net.obvj.jep.util.DateUtils;
import net.obvj.jep.util.NumberUtils;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.Comparative;

public class DateAwareComparative
extends Comparative {
    private static final Double DOUBLE_FALSE = 0.0;
    private static final Double DOUBLE_TRUE = 1.0;

    public DateAwareComparative(int pComparativeId) {
        super(pComparativeId);
    }

    public void run(Stack pStack) throws ParseException {
        this.checkStack(pStack);
        Object parameter2 = pStack.pop();
        Object parameter1 = pStack.pop();
        try {
            Date date1 = DateUtils.parseDate(parameter1);
            Date date2 = DateUtils.parseDate(parameter2);
            boolean result = this.compareDates(date1, date2);
            pStack.push(result ? DOUBLE_TRUE : DOUBLE_FALSE);
        }
        catch (IllegalArgumentException exception) {
            pStack.push(parameter1 instanceof String ? Double.valueOf(NumberUtils.parseDouble(parameter1)) : parameter1);
            pStack.push(parameter2 instanceof String ? Double.valueOf(NumberUtils.parseDouble(parameter2)) : parameter2);
            super.run(pStack);
        }
    }

    protected boolean compareDates(Date date1, Date date2) {
        switch (this.id) {
            case 0: {
                return date1.before(date2);
            }
            case 1: {
                return date1.after(date2);
            }
            case 2: {
                return date1.before(date2) || date1.equals(date2);
            }
            case 3: {
                return date1.after(date2) || date1.equals(date2);
            }
            case 4: {
                return !date1.equals(date2);
            }
            case 5: {
                return date1.equals(date2);
            }
        }
        return false;
    }
}

