/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.jep.functions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import net.obvj.jep.functions.MultiStrategyCommand;
import net.obvj.jep.util.RegexUtils;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class BinaryStringFunction
extends PostfixMathCommand
implements MultiStrategyCommand {
    private final Strategy strategy;

    public BinaryStringFunction(Strategy returnStrategy) {
        this.numberOfParameters = 2;
        this.strategy = returnStrategy;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object arg2 = stack.pop();
        Object arg1 = stack.pop();
        if (arg1 == null) {
            stack.push(Collections.emptyList());
            return;
        }
        if (arg2 == null) {
            throw new IllegalArgumentException("The RegEx cannot be null");
        }
        this.strategy.pushResult(stack, arg1.toString(), arg2.toString());
    }

    @Override
    public Object getStrategy() {
        return this.strategy;
    }

    public static enum Strategy {
        ALL_MATCHES{

            @Override
            void pushResult(Stack stack, String string, String regex) {
                List<String> matches = RegexUtils.findMatches(string, regex);
                stack.push(matches);
            }
        }
        ,
        FIRST_MATCH{

            @Override
            void pushResult(Stack stack, String string, String regex) {
                String matches = RegexUtils.firstMatch(string, regex);
                stack.push(matches);
            }
        }
        ,
        SPLIT{

            @Override
            void pushResult(Stack stack, String string, String regex) {
                List<String> strings = Arrays.asList(string.split(regex));
                stack.push(strings);
            }
        };


        abstract void pushResult(Stack var1, String var2, String var3);
    }
}

