/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.jep;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.obvj.jep.NamedPackage;
import net.obvj.jep.functions.Arabic;
import net.obvj.jep.functions.Average;
import net.obvj.jep.functions.BasicAuthorizationHeader;
import net.obvj.jep.functions.BinaryBooleanFunction;
import net.obvj.jep.functions.BinaryDateFunction;
import net.obvj.jep.functions.BinaryStringFunction;
import net.obvj.jep.functions.Concat;
import net.obvj.jep.functions.Count;
import net.obvj.jep.functions.DateAwareComparative;
import net.obvj.jep.functions.DateFieldGetter;
import net.obvj.jep.functions.DateToString;
import net.obvj.jep.functions.DaysBetween;
import net.obvj.jep.functions.Distinct;
import net.obvj.jep.functions.Element;
import net.obvj.jep.functions.EndOfMonth;
import net.obvj.jep.functions.FormatString;
import net.obvj.jep.functions.Function;
import net.obvj.jep.functions.Http;
import net.obvj.jep.functions.HttpGet;
import net.obvj.jep.functions.HttpHeader;
import net.obvj.jep.functions.HttpResponseHandler;
import net.obvj.jep.functions.IsEmpty;
import net.obvj.jep.functions.IsLeapYear;
import net.obvj.jep.functions.JsonPath;
import net.obvj.jep.functions.Max;
import net.obvj.jep.functions.Min;
import net.obvj.jep.functions.MultiStrategyCommand;
import net.obvj.jep.functions.NormalizeString;
import net.obvj.jep.functions.Now;
import net.obvj.jep.functions.ReadFile;
import net.obvj.jep.functions.Replace;
import net.obvj.jep.functions.Roman;
import net.obvj.jep.functions.StringPaddingFunction;
import net.obvj.jep.functions.StringToDate;
import net.obvj.jep.functions.TypeOf;
import net.obvj.jep.functions.UUID;
import net.obvj.jep.functions.UnaryBooleanFunction;
import net.obvj.jep.functions.UnaryEncryptionFunction;
import net.obvj.jep.functions.UnaryStringFunction;
import net.obvj.jep.functions.UnarySystemFunction;
import net.obvj.jep.functions.XPath;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.nfunk.jep.JEP;
import org.nfunk.jep.OperatorSet;
import org.nfunk.jep.function.PostfixMathCommandI;
import org.nfunk.jep.type.NumberFactory;

public class JEPContextFactory {
    private static final String MSG_ANNOTATION_NOT_FOUND_IN_CLASS = "@Function annotation not found in class: %s";
    private static final String MSG_ANNOTATION_NOT_FOUND_IN_STRATEGY = "@Function annotation not found in strategy enum type: %s";
    private static final Map<NamedPackage, List<Supplier<PostfixMathCommandI>>> FUNCTION_FACTORY_BY_PACKAGE = new EnumMap<NamedPackage, List<Supplier<PostfixMathCommandI>>>(NamedPackage.class);

    private static void registerFunction(NamedPackage namedPackage, Supplier<PostfixMathCommandI> supplier) {
        FUNCTION_FACTORY_BY_PACKAGE.computeIfAbsent(namedPackage, k -> new ArrayList()).add(supplier);
    }

    private JEPContextFactory() {
        throw new IllegalStateException("No instances allowed");
    }

    public static JEP newContext(NamedPackage ... namedPackages) {
        return JEPContextFactory.newContext(null, false, true, false, null, namedPackages);
    }

    public static JEP newContext(Map<String, Object> contextMap, NamedPackage ... namedPackages) {
        return JEPContextFactory.newContext(contextMap, false, true, false, null, namedPackages);
    }

    public static JEP newContext(Map<String, Object> contextMap, boolean traverse, boolean allowUndeclared, boolean implicitMultiplication, NumberFactory numberFactory, NamedPackage ... namedPackages) {
        JEP jep = new JEP(traverse, allowUndeclared, implicitMultiplication, numberFactory);
        jep.setAllowAssignment(true);
        jep.addStandardFunctions();
        JEPContextFactory.addCustomFunctions(jep, namedPackages);
        if (contextMap != null) {
            JEPContextFactory.addVariables(jep, contextMap);
        }
        return jep;
    }

    public static void addCustomFunctions(JEP jep, NamedPackage ... namedPackages) {
        JEPContextFactory.getFunctions(namedPackages).map(Supplier::get).forEach(function -> JEPContextFactory.addAnnotatedFunction(jep, function));
        OperatorSet operators = jep.getOperatorSet();
        operators.getLT().setPFMC((PostfixMathCommandI)new DateAwareComparative(0));
        operators.getGT().setPFMC((PostfixMathCommandI)new DateAwareComparative(1));
        operators.getLE().setPFMC((PostfixMathCommandI)new DateAwareComparative(2));
        operators.getGE().setPFMC((PostfixMathCommandI)new DateAwareComparative(3));
        operators.getNE().setPFMC((PostfixMathCommandI)new DateAwareComparative(4));
        operators.getEQ().setPFMC((PostfixMathCommandI)new DateAwareComparative(5));
        Element elementCommand = new Element();
        JEPContextFactory.addAnnotatedFunction(jep, (PostfixMathCommandI)elementCommand);
        operators.getElement().setPFMC((PostfixMathCommandI)elementCommand);
    }

    private static Stream<Supplier<PostfixMathCommandI>> getAllFunctions() {
        return FUNCTION_FACTORY_BY_PACKAGE.values().stream().flatMap(Collection::stream);
    }

    private static Stream<Supplier<PostfixMathCommandI>> getFunctions(NamedPackage ... namedPackages) {
        if (namedPackages == null || namedPackages.length == 0) {
            return JEPContextFactory.getAllFunctions();
        }
        if (namedPackages.length == 1) {
            return FUNCTION_FACTORY_BY_PACKAGE.getOrDefault((Object)namedPackages[0], Collections.emptyList()).stream();
        }
        return Arrays.stream(namedPackages).map(FUNCTION_FACTORY_BY_PACKAGE::get).filter(Objects::nonNull).flatMap(Collection::stream);
    }

    protected static void addAnnotatedFunction(JEP jep, PostfixMathCommandI function) {
        Optional<Function> annotation = JEPContextFactory.getAnnotation(function);
        if (!annotation.isPresent()) {
            throw new IllegalStateException(String.format(MSG_ANNOTATION_NOT_FOUND_IN_CLASS, function));
        }
        Arrays.stream(annotation.get().value()).forEach(alias -> jep.addFunction(alias, function));
    }

    private static Optional<Function> getAnnotation(PostfixMathCommandI function) {
        return function instanceof MultiStrategyCommand ? JEPContextFactory.getAnnotation((MultiStrategyCommand)function) : Optional.ofNullable(function.getClass().getAnnotation(Function.class));
    }

    private static Optional<Function> getAnnotation(MultiStrategyCommand function) {
        Object strategy = function.getStrategy();
        List annotations = FieldUtils.getFieldsListWithAnnotation(strategy.getClass(), Function.class);
        Field strategyField = annotations.stream().filter(field -> field.getName().equals(strategy.toString())).findAny().orElseThrow(() -> new IllegalStateException(String.format(MSG_ANNOTATION_NOT_FOUND_IN_STRATEGY, strategy.toString())));
        return Optional.ofNullable(strategyField.getAnnotation(Function.class));
    }

    public static void addVariables(JEP jep, Map<String, Object> contextMap) {
        if (jep == null) {
            throw new IllegalArgumentException("A null JEP object was received");
        }
        if (contextMap != null) {
            jep.getSymbolTable().putAll(contextMap);
        }
    }

    static {
        JEPContextFactory.registerFunction(NamedPackage.STRING, Concat::new);
        JEPContextFactory.registerFunction(NamedPackage.STRING, FormatString::new);
        JEPContextFactory.registerFunction(NamedPackage.STRING, NormalizeString::new);
        JEPContextFactory.registerFunction(NamedPackage.STRING, () -> new BinaryBooleanFunction(BinaryBooleanFunction.Strategy.STRING_ENDS_WITH));
        JEPContextFactory.registerFunction(NamedPackage.STRING, () -> new BinaryBooleanFunction(BinaryBooleanFunction.Strategy.STRING_MATCHES));
        JEPContextFactory.registerFunction(NamedPackage.STRING, () -> new BinaryBooleanFunction(BinaryBooleanFunction.Strategy.STRING_STARTS_WITH));
        JEPContextFactory.registerFunction(NamedPackage.STRING, () -> new BinaryStringFunction(BinaryStringFunction.Strategy.ALL_MATCHES));
        JEPContextFactory.registerFunction(NamedPackage.STRING, () -> new BinaryStringFunction(BinaryStringFunction.Strategy.FIRST_MATCH));
        JEPContextFactory.registerFunction(NamedPackage.STRING, () -> new BinaryStringFunction(BinaryStringFunction.Strategy.SPLIT));
        JEPContextFactory.registerFunction(NamedPackage.STRING, () -> new Replace(Replace.Strategy.NORMAL));
        JEPContextFactory.registerFunction(NamedPackage.STRING, () -> new Replace(Replace.Strategy.REGEX));
        JEPContextFactory.registerFunction(NamedPackage.STRING, () -> new StringPaddingFunction(StringPaddingFunction.Strategy.LEFT_PAD));
        JEPContextFactory.registerFunction(NamedPackage.STRING, () -> new StringPaddingFunction(StringPaddingFunction.Strategy.RIGHT_PAD));
        JEPContextFactory.registerFunction(NamedPackage.STRING, () -> new UnaryStringFunction(UnaryStringFunction.Strategy.CAMEL));
        JEPContextFactory.registerFunction(NamedPackage.STRING, () -> new UnaryStringFunction(UnaryStringFunction.Strategy.LOWER));
        JEPContextFactory.registerFunction(NamedPackage.STRING, () -> new UnaryStringFunction(UnaryStringFunction.Strategy.PROPER));
        JEPContextFactory.registerFunction(NamedPackage.STRING, () -> new UnaryStringFunction(UnaryStringFunction.Strategy.TRIM));
        JEPContextFactory.registerFunction(NamedPackage.STRING, () -> new UnaryStringFunction(UnaryStringFunction.Strategy.UPPER));
        JEPContextFactory.registerFunction(NamedPackage.DATE, DateToString::new);
        JEPContextFactory.registerFunction(NamedPackage.DATE, DaysBetween::new);
        JEPContextFactory.registerFunction(NamedPackage.DATE, EndOfMonth::new);
        JEPContextFactory.registerFunction(NamedPackage.DATE, IsLeapYear::new);
        JEPContextFactory.registerFunction(NamedPackage.DATE, Now::new);
        JEPContextFactory.registerFunction(NamedPackage.DATE, StringToDate::new);
        JEPContextFactory.registerFunction(NamedPackage.DATE, () -> new DateFieldGetter(DateFieldGetter.DateField.YEAR));
        JEPContextFactory.registerFunction(NamedPackage.DATE, () -> new DateFieldGetter(DateFieldGetter.DateField.QUARTER));
        JEPContextFactory.registerFunction(NamedPackage.DATE, () -> new DateFieldGetter(DateFieldGetter.DateField.MONTH));
        JEPContextFactory.registerFunction(NamedPackage.DATE, () -> new DateFieldGetter(DateFieldGetter.DateField.ISO_WEEK_NUMBER));
        JEPContextFactory.registerFunction(NamedPackage.DATE, () -> new DateFieldGetter(DateFieldGetter.DateField.WEEK_DAY));
        JEPContextFactory.registerFunction(NamedPackage.DATE, () -> new DateFieldGetter(DateFieldGetter.DateField.DAY));
        JEPContextFactory.registerFunction(NamedPackage.DATE, () -> new DateFieldGetter(DateFieldGetter.DateField.HOUR));
        JEPContextFactory.registerFunction(NamedPackage.DATE, () -> new DateFieldGetter(DateFieldGetter.DateField.MINUTE));
        JEPContextFactory.registerFunction(NamedPackage.DATE, () -> new DateFieldGetter(DateFieldGetter.DateField.SECOND));
        JEPContextFactory.registerFunction(NamedPackage.DATE, () -> new DateFieldGetter(DateFieldGetter.DateField.MILLISECOND));
        JEPContextFactory.registerFunction(NamedPackage.DATE, () -> new BinaryDateFunction(BinaryDateFunction.Strategy.ADD_YEARS));
        JEPContextFactory.registerFunction(NamedPackage.DATE, () -> new BinaryDateFunction(BinaryDateFunction.Strategy.ADD_QUARTERS));
        JEPContextFactory.registerFunction(NamedPackage.DATE, () -> new BinaryDateFunction(BinaryDateFunction.Strategy.ADD_MONTHS));
        JEPContextFactory.registerFunction(NamedPackage.DATE, () -> new BinaryDateFunction(BinaryDateFunction.Strategy.ADD_WEEKS));
        JEPContextFactory.registerFunction(NamedPackage.DATE, () -> new BinaryDateFunction(BinaryDateFunction.Strategy.ADD_DAYS));
        JEPContextFactory.registerFunction(NamedPackage.DATE, () -> new BinaryDateFunction(BinaryDateFunction.Strategy.ADD_HOURS));
        JEPContextFactory.registerFunction(NamedPackage.DATE, () -> new BinaryDateFunction(BinaryDateFunction.Strategy.ADD_MINUTES));
        JEPContextFactory.registerFunction(NamedPackage.DATE, () -> new BinaryDateFunction(BinaryDateFunction.Strategy.ADD_SECONDS));
        JEPContextFactory.registerFunction(NamedPackage.DATA_MANIPULATION, JsonPath::new);
        JEPContextFactory.registerFunction(NamedPackage.DATA_MANIPULATION, XPath::new);
        JEPContextFactory.registerFunction(NamedPackage.STATISTICS, Average::new);
        JEPContextFactory.registerFunction(NamedPackage.STATISTICS, Count::new);
        JEPContextFactory.registerFunction(NamedPackage.STATISTICS, Max::new);
        JEPContextFactory.registerFunction(NamedPackage.STATISTICS, Min::new);
        JEPContextFactory.registerFunction(NamedPackage.RANDOM, UUID::new);
        JEPContextFactory.registerFunction(NamedPackage.UTIL, Distinct::new);
        JEPContextFactory.registerFunction(NamedPackage.UTIL, IsEmpty::new);
        JEPContextFactory.registerFunction(NamedPackage.UTIL, ReadFile::new);
        JEPContextFactory.registerFunction(NamedPackage.UTIL, TypeOf::new);
        JEPContextFactory.registerFunction(NamedPackage.UTIL, () -> new UnaryBooleanFunction(UnaryBooleanFunction.Strategy.IS_DECIMAL));
        JEPContextFactory.registerFunction(NamedPackage.UTIL, () -> new UnaryBooleanFunction(UnaryBooleanFunction.Strategy.IS_INTEGER));
        JEPContextFactory.registerFunction(NamedPackage.UTIL, () -> new UnarySystemFunction(UnarySystemFunction.Strategy.GET_ENV));
        JEPContextFactory.registerFunction(NamedPackage.UTIL, () -> new UnarySystemFunction(UnarySystemFunction.Strategy.GET_SYSTEM_PROPERTY));
        JEPContextFactory.registerFunction(NamedPackage.CRYPTO, () -> new UnaryEncryptionFunction(UnaryEncryptionFunction.EncryptionAlgorithm.SHA256));
        JEPContextFactory.registerFunction(NamedPackage.CRYPTO, () -> new UnaryEncryptionFunction(UnaryEncryptionFunction.EncryptionAlgorithm.TO_BASE64));
        JEPContextFactory.registerFunction(NamedPackage.CRYPTO, () -> new UnaryEncryptionFunction(UnaryEncryptionFunction.EncryptionAlgorithm.FROM_BASE64));
        JEPContextFactory.registerFunction(NamedPackage.WEB, BasicAuthorizationHeader::new);
        JEPContextFactory.registerFunction(NamedPackage.WEB, Http::new);
        JEPContextFactory.registerFunction(NamedPackage.WEB, HttpGet::new);
        JEPContextFactory.registerFunction(NamedPackage.WEB, HttpHeader::new);
        JEPContextFactory.registerFunction(NamedPackage.WEB, () -> new HttpResponseHandler(HttpResponseHandler.Strategy.GET_RESPONSE));
        JEPContextFactory.registerFunction(NamedPackage.WEB, () -> new HttpResponseHandler(HttpResponseHandler.Strategy.GET_STATUS_CODE));
        JEPContextFactory.registerFunction(NamedPackage.MATH, Arabic::new);
        JEPContextFactory.registerFunction(NamedPackage.MATH, Roman::new);
    }
}

