/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.jep.util;

import org.apache.commons.lang3.StringUtils;

public class NumberUtils {
    private NumberUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static Integer getIntegerFromString(String stringValue) {
        if (StringUtils.isEmpty((CharSequence)stringValue)) {
            return null;
        }
        return Double.valueOf(stringValue).intValue();
    }

    public static boolean isInteger(Object object) {
        if (NumberUtils.isNumber(object)) {
            Double doubleValue = NumberUtils.parseDouble(object);
            return NumberUtils.isInteger(doubleValue);
        }
        return false;
    }

    public static boolean isInteger(String stringValue) {
        try {
            return NumberUtils.isInteger(Double.valueOf(stringValue));
        }
        catch (NumberFormatException exception) {
            return false;
        }
    }

    public static boolean isDecimal(String stringValue) {
        try {
            return NumberUtils.isDecimal(Double.valueOf(stringValue));
        }
        catch (NumberFormatException exception) {
            return false;
        }
    }

    public static boolean isInteger(Number numberValue) {
        return numberValue != null && numberValue.doubleValue() % 1.0 == 0.0;
    }

    public static boolean isDecimal(Number numberValue) {
        return numberValue != null && numberValue.doubleValue() % 1.0 != 0.0;
    }

    public static int parseInt(Object object) {
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof String) {
            return Double.valueOf((String)object).intValue();
        }
        throw new NumberFormatException("parseInt() does not support " + (object == null ? "null" : object.getClass().getSimpleName()));
    }

    public static double parseDouble(Object object) {
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof String) {
            return Double.parseDouble(object.toString());
        }
        throw new NumberFormatException("parseDouble() does not support " + (object == null ? "null" : object.getClass().getSimpleName()));
    }

    public static boolean isNumber(Object object) {
        if (object == null || StringUtils.isEmpty((CharSequence)object.toString())) {
            return false;
        }
        if (object instanceof Number) {
            return true;
        }
        try {
            Double.valueOf(String.valueOf(object));
            return true;
        }
        catch (NumberFormatException exception) {
            return false;
        }
    }

    public static boolean containsParsableNumbers(Iterable<?> iterable) {
        for (Object element : iterable) {
            if (NumberUtils.isNumber(element)) continue;
            return false;
        }
        return true;
    }
}

