/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.jep.util;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import java.util.stream.Collectors;
import net.obvj.jep.util.DateUtils;
import net.obvj.jep.util.JsonUtils;
import net.obvj.jep.util.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;

public class CollectionsUtils {
    private static final String ENTRY_SEPARATORS_REGEX = "=|:";
    private static final String ERROR_UNABLE_TO_PARSE_ENTRY = "Unable to parse entry: %s";

    private CollectionsUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static List<Object> asList(Object object) {
        if (object == null) {
            return Collections.emptyList();
        }
        if (object instanceof List) {
            List list = (List)object;
            return list;
        }
        if (object instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)object;
            return JsonUtils.toList(jsonArray);
        }
        if (object instanceof Object[]) {
            return Arrays.asList((Object[])object);
        }
        if (object instanceof String) {
            try {
                JSONArray jsonArray = new JSONArray(object.toString());
                return JsonUtils.toList(jsonArray);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return Collections.singletonList(object);
    }

    public static Map<String, String> asMap(String ... entries) {
        return Arrays.stream(entries).map(CollectionsUtils::parseMapEntry).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static Map.Entry<String, String> parseMapEntry(String entry) {
        if (StringUtils.isEmpty((CharSequence)entry)) {
            throw new IllegalArgumentException(String.format(ERROR_UNABLE_TO_PARSE_ENTRY, "<EMPTY>"));
        }
        String[] strings = entry.split(ENTRY_SEPARATORS_REGEX, 2);
        if (strings.length < 2) {
            throw new IllegalArgumentException(String.format(ERROR_UNABLE_TO_PARSE_ENTRY, entry));
        }
        return new AbstractMap.SimpleEntry<String, String>(strings[0].trim(), strings[1].trim());
    }

    public static Map<Object, Object> createMapOfParsedObjects(Iterable<?> iterable) {
        HashMap<Object, Object> parsedObjectsMap = new HashMap<Object, Object>();
        for (Object element : iterable) {
            if (DateUtils.isParsable(element)) {
                parsedObjectsMap.put(DateUtils.parseDate(element), element);
                continue;
            }
            if (!NumberUtils.isNumber(element)) continue;
            parsedObjectsMap.put(NumberUtils.parseDouble(element), element);
        }
        return parsedObjectsMap;
    }

    public static Object max(Iterable<?> iterable) {
        Map<Object, Object> parsedNumberMap;
        Optional<Double> maxNumber;
        Map<Object, Object> parsedDateMap;
        Optional<Date> maxDate;
        if (DateUtils.containsParsableDates(iterable) && (maxDate = (parsedDateMap = CollectionsUtils.createMapOfParsedObjects(iterable)).keySet().stream().map(DateUtils::parseDate).max(Date::compareTo)).isPresent()) {
            return parsedDateMap.get(maxDate.get());
        }
        if (NumberUtils.containsParsableNumbers(iterable) && (maxNumber = (parsedNumberMap = CollectionsUtils.createMapOfParsedObjects(iterable)).keySet().stream().map(NumberUtils::parseDouble).max(Double::compareTo)).isPresent()) {
            return parsedNumberMap.get(maxNumber.get());
        }
        throw new IllegalArgumentException("Unable to determine the maximum value for the arguments: " + iterable.toString());
    }

    public static Object min(Iterable<?> iterable) {
        Map<Object, Object> parsedNumberMap;
        Map<Object, Object> parsedDateMap;
        Optional<Comparable<Date>> value;
        if (DateUtils.containsParsableDates(iterable) && (value = (parsedDateMap = CollectionsUtils.createMapOfParsedObjects(iterable)).keySet().stream().map(DateUtils::parseDate).min(Date::compareTo)).isPresent()) {
            return parsedDateMap.get(value.get());
        }
        if (NumberUtils.containsParsableNumbers(iterable) && (value = (parsedNumberMap = CollectionsUtils.createMapOfParsedObjects(iterable)).keySet().stream().map(NumberUtils::parseDouble).min(Double::compareTo)).isPresent()) {
            return parsedNumberMap.get(value.get());
        }
        throw new IllegalArgumentException("Unable to compare minimum value for the arguments: " + iterable.toString());
    }

    public static List<Object> distinctList(List<Object> list) {
        if (CollectionsUtils.isEmpty(list)) {
            return list;
        }
        return list.stream().distinct().collect(Collectors.toList());
    }

    public static Stack<Object> newParametersStack(Object ... parameters) {
        Stack<Object> stack = new Stack<Object>();
        for (Object param : parameters) {
            stack.push(param);
        }
        return stack;
    }
}

