/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.jep.functions;

import java.util.Collection;
import java.util.Stack;
import net.obvj.jep.functions.Function;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

@Function(value={"count", "length"})
public class Count
extends PostfixMathCommand {
    public Count() {
        this.numberOfParameters = 1;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        stack.push(this.count(stack.pop()));
    }

    protected int count(Collection<?> collection) {
        return collection == null ? 0 : collection.size();
    }

    protected int count(JSONArray jsonArray) {
        return jsonArray == null ? 0 : jsonArray.length();
    }

    private int count(String string) {
        try {
            return StringUtils.isEmpty((CharSequence)string) ? 0 : new JSONArray(string).length();
        }
        catch (JSONException exception) {
            return 1;
        }
    }

    public int count(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Collection) {
            return this.count((Collection)object);
        }
        if (object instanceof JSONArray) {
            return this.count((JSONArray)object);
        }
        if (object instanceof Object[]) {
            return ((Object[])object).length;
        }
        if (object instanceof String) {
            return this.count((String)object);
        }
        return 1;
    }
}

