/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.jep.functions;

import java.util.Calendar;
import java.util.Date;
import java.util.Stack;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.obvj.jep.functions.MultiStrategyCommand;
import net.obvj.jep.util.DateUtils;
import net.obvj.jep.util.NumberUtils;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class BinaryDateFunction
extends PostfixMathCommand
implements MultiStrategyCommand {
    private final Strategy strategy;

    public BinaryDateFunction(Strategy returnStrategy) {
        this.numberOfParameters = 2;
        this.strategy = returnStrategy;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object arg2 = stack.pop();
        Object arg1 = stack.pop();
        Date date = DateUtils.parseDate(arg1);
        if (!NumberUtils.isInteger(arg2)) {
            throw new IllegalArgumentException("The second argument must be an integer number");
        }
        int amount = NumberUtils.parseInt(arg2);
        Date result = (Date)this.strategy.apply(date, amount);
        stack.push(result);
    }

    @Override
    public Object getStrategy() {
        return this.strategy;
    }

    public static enum Strategy implements BiFunction<Date, Integer, Date>
    {
        ADD_SECONDS{

            @Override
            public Date apply(Date date, Integer amount) {
                return this.apply(date, (Calendar calendar) -> calendar.add(13, amount));
            }
        }
        ,
        ADD_MINUTES{

            @Override
            public Date apply(Date date, Integer amount) {
                return this.apply(date, (Calendar calendar) -> calendar.add(12, amount));
            }
        }
        ,
        ADD_HOURS{

            @Override
            public Date apply(Date date, Integer amount) {
                return this.apply(date, (Calendar calendar) -> calendar.add(11, amount));
            }
        }
        ,
        ADD_DAYS{

            @Override
            public Date apply(Date date, Integer amount) {
                return this.apply(date, (Calendar calendar) -> calendar.add(5, amount));
            }
        }
        ,
        ADD_WEEKS{

            @Override
            public Date apply(Date date, Integer amount) {
                return this.apply(date, (Calendar calendar) -> calendar.add(4, amount));
            }
        }
        ,
        ADD_MONTHS{

            @Override
            public Date apply(Date date, Integer amount) {
                return this.apply(date, (Calendar calendar) -> calendar.add(2, amount));
            }
        }
        ,
        ADD_QUARTERS{

            @Override
            public Date apply(Date date, Integer amount) {
                return (Date)ADD_MONTHS.apply(date, amount * 3);
            }
        }
        ,
        ADD_YEARS{

            @Override
            public Date apply(Date date, Integer amount) {
                return this.apply(date, (Calendar calendar) -> calendar.add(1, amount));
            }
        };


        @Override
        public Date apply(Date date, Consumer<Calendar> consumer) {
            Calendar calendar = DateUtils.toCalendar(date);
            consumer.accept(calendar);
            return calendar.getTime();
        }
    }
}

