/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.jep;

import java.util.Map;
import net.obvj.jep.JEPContextFactory;
import net.obvj.jep.NamedPackage;
import org.apache.commons.lang3.StringUtils;
import org.nfunk.jep.JEP;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.SymbolTable;
import org.nfunk.jep.TokenMgrError;
import org.nfunk.jep.Variable;

public class ExpressionEvaluator {
    private static final boolean DEFAULT_UPDATE_SOURCE_MAP_FLAG = false;
    private final String expression;

    public ExpressionEvaluator(String expression) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            throw new IllegalArgumentException("The expression cannot be empty");
        }
        ExpressionEvaluator.validateExpression(expression);
        this.expression = expression;
    }

    public static void validateExpression(String expression) {
        try {
            JEPContextFactory.newContext(new NamedPackage[0]).parse(expression);
        }
        catch (ParseException | TokenMgrError exception) {
            throw new IllegalArgumentException("Invalid expression: " + expression, exception);
        }
    }

    public Object evaluate(Map<String, Object> variables) throws ParseException {
        return this.evaluate(variables, false);
    }

    public Object evaluate(Map<String, Object> variables, boolean updateSourceMap) throws ParseException {
        JEP evaluationContext = JEPContextFactory.newContext(variables, new NamedPackage[0]);
        Node node = evaluationContext.parseExpression(this.expression);
        Object result = evaluationContext.evaluate(node);
        if (updateSourceMap) {
            this.updateExternalMap(variables, evaluationContext.getSymbolTable());
        }
        return result;
    }

    private void updateExternalMap(Map<String, Object> map, SymbolTable internalTable) {
        internalTable.forEach((key, value) -> map.put((String)key, ((Variable)value).getValue()));
    }
}

