/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.jep;

import com.github.freva.asciitable.AsciiTable;
import com.github.freva.asciitable.Column;
import com.github.freva.asciitable.ColumnData;
import com.github.freva.asciitable.HorizontalAlign;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Scanner;
import net.obvj.jep.JEPContextFactory;
import net.obvj.jep.NamedPackage;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.nfunk.jep.JEP;
import org.nfunk.jep.Node;
import org.nfunk.jep.SymbolTable;

public class Console
implements Runnable {
    private static final String PROMPT = "JEP> ";
    protected final InputStream in;
    protected final PrintStream out;
    private JEP jep = JEPContextFactory.newContext(new NamedPackage[0]);

    public Console() {
        this(null, null);
    }

    protected Console(InputStream in, PrintStream out) {
        this.in = (InputStream)ObjectUtils.defaultIfNull((Object)in, (Object)System.in);
        this.out = (PrintStream)ObjectUtils.defaultIfNull((Object)out, (Object)System.out);
    }

    @Override
    public void run() {
        this.printHeader();
        try (Scanner scanner = new Scanner(this.in);){
            this.prompt();
            this.loop(scanner);
        }
        this.out.println("Goodbye!");
    }

    private void loop(Scanner scanner) {
        while (scanner.hasNext()) {
            String line = scanner.nextLine();
            if (!StringUtils.isEmpty((CharSequence)line)) {
                if (StringUtils.equalsAny((CharSequence)line.trim(), (CharSequence[])new CharSequence[]{"exit", "quit"})) break;
                this.handleLine(line);
            }
            this.out.println();
            this.prompt();
        }
    }

    private void printHeader() {
        this.out.println("     __ _____ _____");
        this.out.println("  __|  |   __|  _  |  obvj.net");
        this.out.println(" |  |  |   __|   __|  JEP-DATA-EXTENSION");
        this.out.println(" |_____|_____|__|");
        this.out.println();
        this.out.println(" Enter your expression or type ...");
        this.out.println();
        this.out.println(" > functions  to list functions");
        this.out.println(" > operators  to list operators");
        this.out.println(" > variables  to list variables");
        this.out.println(" > exit/quit  to quit the console");
        this.out.println();
    }

    private void prompt() {
        this.out.flush();
        this.out.print(PROMPT);
    }

    private void handleLine(String line) {
        Optional<Command> command = Command.getCommand(line);
        if (command.isPresent()) {
            command.get().execute(this.jep, this.out);
            return;
        }
        this.handleExpression(line);
    }

    private void handleExpression(String line) {
        try {
            Node node = this.jep.parse(line);
            Object result = this.jep.evaluate(node);
            this.out.println(result);
        }
        catch (Throwable exception) {
            this.handleThrowable(exception);
        }
    }

    private void handleThrowable(Throwable throwable) {
        this.out.println(throwable.getClass().getName() + ": " + throwable.getMessage());
    }

    public static void main(String[] args) {
        new Console().run();
    }

    private static enum Command {
        FUNCTIONS("functions"){

            @Override
            public void execute(JEP jep, PrintStream out) {
                out.println("\nAvailable functions:");
                jep.getFunctionTable().keySet().stream().sorted().forEach(alias -> out.println(" - " + alias));
            }
        }
        ,
        OPERATORS("operators"){

            @Override
            public void execute(JEP jep, PrintStream out) {
                out.println("\nAvailable operators:");
                Arrays.stream(jep.getOperatorSet().getOperators()).forEach(operator -> out.println(" - " + operator));
            }
        }
        ,
        VARIABLES("variables"){
            private final List<ColumnData<Pair<String, Object>>> columns = Arrays.asList(new Column().header("Name").headerAlign(HorizontalAlign.CENTER).dataAlign(HorizontalAlign.RIGHT).with(Pair::getKey), new Column().header("Type").headerAlign(HorizontalAlign.CENTER).dataAlign(HorizontalAlign.LEFT).with(this::getType), new Column().header("Value").headerAlign(HorizontalAlign.CENTER).dataAlign(HorizontalAlign.LEFT).with(this::getValue));

            @Override
            public void execute(JEP jep, PrintStream out) {
                SymbolTable symbolTable = jep.getSymbolTable();
                if (symbolTable.isEmpty()) {
                    out.println("No variable set");
                    return;
                }
                List<Pair<String, Object>> entryList = this.parseEntries(symbolTable);
                String result = AsciiTable.getTable(entryList, this.columns);
                out.println("\n" + result);
            }

            private List<Pair<String, Object>> parseEntries(SymbolTable symbolTable) {
                ArrayList<Pair<String, Object>> entryList = new ArrayList<Pair<String, Object>>();
                symbolTable.keySet().forEach(key -> {
                    Object value = symbolTable.getValue(key);
                    entryList.add(Pair.of((Object)String.valueOf(key), (Object)value));
                });
                entryList.sort(Comparator.comparing(Pair::getKey));
                return entryList;
            }

            private String getType(Pair<String, Object> pair) {
                Object value = pair.getValue();
                return value != null ? value.getClass().getName() : "null";
            }

            private String getValue(Pair<String, Object> pair) {
                return String.valueOf(pair.getValue());
            }
        };

        private String alias;

        private Command(String alias) {
            this.alias = alias;
        }

        public String getAlias() {
            return this.alias;
        }

        public static Optional<Command> getCommand(String alias) {
            return Arrays.stream(Command.values()).filter(command -> command.getAlias().equals(alias)).findFirst();
        }

        public abstract void execute(JEP var1, PrintStream var2);
    }
}

