/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.jep.functions;

import java.util.Stack;
import net.obvj.jep.functions.MultiStrategyCommand;
import net.obvj.jep.util.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class StringPaddingFunction
extends PostfixMathCommand
implements MultiStrategyCommand {
    private static final String DEFAULT_PADDING_STR = " ";
    private final Strategy strategy;

    public StringPaddingFunction(Strategy strategy) {
        this.numberOfParameters = -1;
        this.strategy = strategy;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        if (this.curNumberOfParameters < 2 || this.curNumberOfParameters > 3) {
            throw new ParseException("This funcion accepts two or three arguments");
        }
        String padString = this.curNumberOfParameters == 3 ? stack.pop().toString() : DEFAULT_PADDING_STR;
        int size = NumberUtils.parseInt(stack.pop());
        String input = stack.pop().toString();
        String result = input == null ? null : this.strategy.execute(input, size, padString);
        stack.push(result);
    }

    @Override
    public Object getStrategy() {
        return this.strategy;
    }

    public static enum Strategy {
        RIGHT_PAD{

            @Override
            public String execute(String input, Integer size, String padString) {
                return StringUtils.rightPad((String)input, (int)size, (String)padString);
            }
        }
        ,
        LEFT_PAD{

            @Override
            public String execute(String input, Integer size, String padString) {
                return StringUtils.leftPad((String)input, (int)size, (String)padString);
            }
        };


        public abstract String execute(String var1, Integer var2, String var3);
    }
}

