/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.jep.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class RegexUtils {
    protected static final Pattern PATTERN_UNIX_LIKE_VARIABLE_PLACEHOLDER = Pattern.compile("(\\$\\{)[\\w]+(\\})");
    protected static final Pattern PATTERN_UNIX_LIKE_VARIABLE_NAME = Pattern.compile("(?<=\\$\\{)[\\w]+(?=\\})");

    private RegexUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean matches(String string, Pattern pattern) {
        if (StringUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        Matcher matcher = pattern.matcher(string);
        return matcher.find();
    }

    public static boolean matches(String string, String regex) {
        Pattern pattern = Pattern.compile(regex);
        return RegexUtils.matches(string, pattern);
    }

    public static List<String> findMatches(String string, Pattern pattern) {
        if (StringUtils.isEmpty((CharSequence)string)) {
            return Collections.emptyList();
        }
        ArrayList<String> expressions = new ArrayList<String>();
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            expressions.add(matcher.group());
        }
        return expressions;
    }

    public static List<String> findMatches(String string, String regex) {
        Pattern pattern = Pattern.compile(regex);
        return RegexUtils.findMatches(string, pattern);
    }

    public static String firstMatch(String string, Pattern pattern) {
        if (StringUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return matcher.group();
        }
        return "";
    }

    public static String firstMatch(String string, String regex) {
        Pattern pattern = Pattern.compile(regex);
        return RegexUtils.firstMatch(string, pattern);
    }

    public static String replaceMatches(String string, String regex, String replacement) {
        if (StringUtils.isEmpty((CharSequence)string)) {
            return string;
        }
        Pattern pattern = Pattern.compile(regex);
        return pattern.matcher(string).replaceAll(replacement);
    }

    public static boolean hasUnixLikeVariablePlaceholders(String string) {
        List<String> placeholders = RegexUtils.findUnixLikeVariablePlaceholders(string);
        return !placeholders.isEmpty();
    }

    public static List<String> findUnixLikeVariablePlaceholders(String string) {
        return RegexUtils.findMatches(string, PATTERN_UNIX_LIKE_VARIABLE_PLACEHOLDER);
    }

    private static String findUnixLikeVariableName(String placeholder) {
        return RegexUtils.firstMatch(placeholder, PATTERN_UNIX_LIKE_VARIABLE_NAME);
    }

    public static String replacePlaceholdersWithVariables(String string, Map<String, Object> variables) {
        if (StringUtils.isEmpty((CharSequence)string)) {
            return string;
        }
        String resultString = string;
        List<String> placeholders = RegexUtils.findUnixLikeVariablePlaceholders(string);
        for (String placeholder : placeholders) {
            String variableName = RegexUtils.findUnixLikeVariableName(placeholder);
            resultString = resultString.replace(placeholder, String.valueOf(variables.get(variableName)));
        }
        return resultString;
    }
}

