/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.jep.functions;

import java.util.Stack;
import java.util.function.Predicate;
import net.obvj.jep.functions.MultiStrategyCommand;
import net.obvj.jep.util.NumberUtils;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class UnaryBooleanFunction
extends PostfixMathCommand
implements MultiStrategyCommand {
    protected static final double FALSE = 0.0;
    protected static final double TRUE = 1.0;
    private final Strategy strategy;

    public UnaryBooleanFunction(Strategy strategy) {
        this.numberOfParameters = 1;
        this.strategy = strategy;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object parameter = stack.pop();
        boolean isEmpty = this.strategy.execute(parameter);
        stack.push(isEmpty ? 1.0 : 0.0);
    }

    @Override
    public Object getStrategy() {
        return this.strategy;
    }

    public static enum Strategy {
        IS_INTEGER(object -> NumberUtils.isNumber(object) && NumberUtils.isInteger(NumberUtils.parseDouble(object))),
        IS_DECIMAL(object -> NumberUtils.isNumber(object) && NumberUtils.isDecimal(NumberUtils.parseDouble(object)));

        private Predicate<Object> predicate;

        private Strategy(Predicate<Object> predicate) {
            this.predicate = predicate;
        }

        public boolean execute(Object object) {
            return this.predicate.test(object);
        }
    }
}

