/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.jep.functions;

import java.util.Date;
import java.util.Stack;
import net.obvj.jep.functions.Function;
import net.obvj.jep.util.DateUtils;
import org.apache.commons.lang3.StringUtils;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

@Function(value={"date2str"})
public class DateToString
extends PostfixMathCommand {
    public DateToString() {
        this.numberOfParameters = 2;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object pattern = stack.pop();
        Object date = stack.pop();
        if (pattern == null || StringUtils.isEmpty((CharSequence)pattern.toString())) {
            throw new IllegalArgumentException("A pattern is required");
        }
        stack.push(DateUtils.formatDate(this.toDate(date), pattern.toString()));
    }

    private Date toDate(Object object) {
        if (object instanceof Date) {
            return (Date)object;
        }
        throw new IllegalArgumentException("Invalid date object received");
    }
}

