/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.jep.functions;

import java.util.Stack;
import java.util.function.Function;
import net.obvj.jep.functions.MultiStrategyCommand;
import net.obvj.jep.http.WebServiceResponse;
import net.obvj.jep.http.WebServiceUtils;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class HttpResponseHandler
extends PostfixMathCommand
implements MultiStrategyCommand {
    private final Strategy strategy;

    public HttpResponseHandler(Strategy strategy) {
        this.numberOfParameters = 1;
        this.strategy = strategy;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object parameter = stack.pop();
        if (!(parameter instanceof WebServiceResponse)) {
            throw new ParseException("Not a WebServiceResponse object");
        }
        WebServiceResponse webServiceResponse = (WebServiceResponse)parameter;
        stack.push(this.strategy.execute(webServiceResponse));
    }

    @Override
    public Object getStrategy() {
        return this.strategy;
    }

    public static enum Strategy {
        GET_STATUS_CODE(WebServiceUtils::getStatusCode),
        GET_RESPONSE(WebServiceUtils::getResponseAsString);

        private Function<WebServiceResponse, Object> function;

        private Strategy(Function<WebServiceResponse, Object> returnStrategy) {
            this.function = returnStrategy;
        }

        public Object execute(WebServiceResponse webServiceResponse) {
            return this.function.apply(webServiceResponse);
        }
    }
}

