/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.jep;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.obvj.jep.functions.Arabic;
import net.obvj.jep.functions.Average;
import net.obvj.jep.functions.BasicAuthorizationHeader;
import net.obvj.jep.functions.BinaryBooleanFunction;
import net.obvj.jep.functions.BinaryStringFunction;
import net.obvj.jep.functions.Concat;
import net.obvj.jep.functions.Count;
import net.obvj.jep.functions.DateAwareComparative;
import net.obvj.jep.functions.DateFieldGetter;
import net.obvj.jep.functions.DateToString;
import net.obvj.jep.functions.DaysBetween;
import net.obvj.jep.functions.Distinct;
import net.obvj.jep.functions.Element;
import net.obvj.jep.functions.EndOfMonth;
import net.obvj.jep.functions.FormatString;
import net.obvj.jep.functions.Function;
import net.obvj.jep.functions.Http;
import net.obvj.jep.functions.HttpGet;
import net.obvj.jep.functions.HttpHeader;
import net.obvj.jep.functions.HttpResponseHandler;
import net.obvj.jep.functions.IsEmpty;
import net.obvj.jep.functions.IsLeapYear;
import net.obvj.jep.functions.JsonPath;
import net.obvj.jep.functions.Max;
import net.obvj.jep.functions.Min;
import net.obvj.jep.functions.MultiStrategyCommand;
import net.obvj.jep.functions.NormalizeString;
import net.obvj.jep.functions.Now;
import net.obvj.jep.functions.ReadFile;
import net.obvj.jep.functions.Replace;
import net.obvj.jep.functions.Roman;
import net.obvj.jep.functions.StringPaddingFunction;
import net.obvj.jep.functions.StringToDate;
import net.obvj.jep.functions.TypeOf;
import net.obvj.jep.functions.UUID;
import net.obvj.jep.functions.UnaryBooleanFunction;
import net.obvj.jep.functions.UnaryEncryptionFunction;
import net.obvj.jep.functions.UnaryStringFunction;
import net.obvj.jep.functions.UnarySystemFunction;
import net.obvj.jep.functions.XPath;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.nfunk.jep.JEP;
import org.nfunk.jep.OperatorSet;
import org.nfunk.jep.function.PostfixMathCommandI;
import org.nfunk.jep.type.NumberFactory;

public class JEPContextFactory {
    private static final String MSG_ANNOTATION_NOT_FOUND_IN_CLASS = "@Function annotation not found in class: %s";
    private static final String MSG_ANNOTATION_NOT_FOUND_IN_STRATEGY = "@Function annotation not found in strategy enum type: %s";
    private static final List<Supplier<PostfixMathCommandI>> CUSTOM_FUNCTIONS = new ArrayList<Supplier<PostfixMathCommandI>>();

    private JEPContextFactory() {
        throw new IllegalStateException("No instances allowed");
    }

    public static JEP newContext() {
        return JEPContextFactory.newContext(null, false, true, false, null);
    }

    public static JEP newContext(Map<String, Object> contextMap) {
        return JEPContextFactory.newContext(contextMap, false, true, false, null);
    }

    public static JEP newContext(Map<String, Object> contextMap, boolean traverse, boolean allowUndeclared, boolean implicitMultiplication, NumberFactory numberFactory) {
        JEP jep = new JEP(traverse, allowUndeclared, implicitMultiplication, numberFactory);
        jep.setAllowAssignment(true);
        jep.addStandardFunctions();
        JEPContextFactory.addCustomFunctions(jep);
        if (contextMap != null) {
            JEPContextFactory.addVariables(jep, contextMap);
        }
        return jep;
    }

    public static void addCustomFunctions(JEP jep) {
        CUSTOM_FUNCTIONS.stream().map(Supplier::get).forEach(function -> JEPContextFactory.addAnnotatedFunction(jep, function));
        OperatorSet operators = jep.getOperatorSet();
        operators.getLT().setPFMC((PostfixMathCommandI)new DateAwareComparative(0));
        operators.getGT().setPFMC((PostfixMathCommandI)new DateAwareComparative(1));
        operators.getLE().setPFMC((PostfixMathCommandI)new DateAwareComparative(2));
        operators.getGE().setPFMC((PostfixMathCommandI)new DateAwareComparative(3));
        operators.getNE().setPFMC((PostfixMathCommandI)new DateAwareComparative(4));
        operators.getEQ().setPFMC((PostfixMathCommandI)new DateAwareComparative(5));
        Element elementCommand = new Element();
        JEPContextFactory.addAnnotatedFunction(jep, (PostfixMathCommandI)elementCommand);
        operators.getElement().setPFMC((PostfixMathCommandI)elementCommand);
    }

    protected static void addAnnotatedFunction(JEP jep, PostfixMathCommandI function) {
        Optional<Function> annotation = JEPContextFactory.getAnnotation(function);
        if (!annotation.isPresent()) {
            throw new IllegalStateException(String.format(MSG_ANNOTATION_NOT_FOUND_IN_CLASS, function));
        }
        Arrays.stream(annotation.get().value()).forEach(alias -> jep.addFunction(alias, function));
    }

    private static Optional<Function> getAnnotation(PostfixMathCommandI function) {
        return function instanceof MultiStrategyCommand ? JEPContextFactory.getAnnotation((MultiStrategyCommand)function) : Optional.ofNullable(function.getClass().getAnnotation(Function.class));
    }

    private static Optional<Function> getAnnotation(MultiStrategyCommand function) {
        Object strategy = function.getStrategy();
        List annotations = FieldUtils.getFieldsListWithAnnotation(strategy.getClass(), Function.class);
        Field strategyField = annotations.stream().filter(field -> field.getName().equals(strategy.toString())).findAny().orElseThrow(() -> new IllegalStateException(String.format(MSG_ANNOTATION_NOT_FOUND_IN_STRATEGY, strategy.toString())));
        return Optional.ofNullable(strategyField.getAnnotation(Function.class));
    }

    public static void addVariables(JEP jep, Map<String, Object> contextMap) {
        if (jep == null) {
            throw new IllegalArgumentException("A null JEP object was received");
        }
        if (contextMap != null) {
            jep.getSymbolTable().putAll(contextMap);
        }
    }

    static {
        CUSTOM_FUNCTIONS.add(Concat::new);
        CUSTOM_FUNCTIONS.add(FormatString::new);
        CUSTOM_FUNCTIONS.add(NormalizeString::new);
        CUSTOM_FUNCTIONS.add(() -> new BinaryBooleanFunction(BinaryBooleanFunction.Strategy.STRING_ENDS_WITH));
        CUSTOM_FUNCTIONS.add(() -> new BinaryBooleanFunction(BinaryBooleanFunction.Strategy.STRING_MATCHES));
        CUSTOM_FUNCTIONS.add(() -> new BinaryBooleanFunction(BinaryBooleanFunction.Strategy.STRING_STARTS_WITH));
        CUSTOM_FUNCTIONS.add(() -> new BinaryStringFunction(BinaryStringFunction.Strategy.ALL_MATCHES));
        CUSTOM_FUNCTIONS.add(() -> new BinaryStringFunction(BinaryStringFunction.Strategy.FIRST_MATCH));
        CUSTOM_FUNCTIONS.add(() -> new BinaryStringFunction(BinaryStringFunction.Strategy.SPLIT));
        CUSTOM_FUNCTIONS.add(() -> new Replace(Replace.Strategy.NORMAL));
        CUSTOM_FUNCTIONS.add(() -> new Replace(Replace.Strategy.REGEX));
        CUSTOM_FUNCTIONS.add(() -> new StringPaddingFunction(StringPaddingFunction.Strategy.LEFT_PAD));
        CUSTOM_FUNCTIONS.add(() -> new StringPaddingFunction(StringPaddingFunction.Strategy.RIGHT_PAD));
        CUSTOM_FUNCTIONS.add(() -> new UnaryStringFunction(UnaryStringFunction.Strategy.CAMEL));
        CUSTOM_FUNCTIONS.add(() -> new UnaryStringFunction(UnaryStringFunction.Strategy.LOWER));
        CUSTOM_FUNCTIONS.add(() -> new UnaryStringFunction(UnaryStringFunction.Strategy.PROPER));
        CUSTOM_FUNCTIONS.add(() -> new UnaryStringFunction(UnaryStringFunction.Strategy.TRIM));
        CUSTOM_FUNCTIONS.add(() -> new UnaryStringFunction(UnaryStringFunction.Strategy.UPPER));
        CUSTOM_FUNCTIONS.add(DateToString::new);
        CUSTOM_FUNCTIONS.add(DaysBetween::new);
        CUSTOM_FUNCTIONS.add(EndOfMonth::new);
        CUSTOM_FUNCTIONS.add(IsLeapYear::new);
        CUSTOM_FUNCTIONS.add(Now::new);
        CUSTOM_FUNCTIONS.add(StringToDate::new);
        CUSTOM_FUNCTIONS.add(() -> new DateFieldGetter(DateFieldGetter.DateField.YEAR));
        CUSTOM_FUNCTIONS.add(() -> new DateFieldGetter(DateFieldGetter.DateField.QUARTER));
        CUSTOM_FUNCTIONS.add(() -> new DateFieldGetter(DateFieldGetter.DateField.MONTH));
        CUSTOM_FUNCTIONS.add(() -> new DateFieldGetter(DateFieldGetter.DateField.ISO_WEEK_NUMBER));
        CUSTOM_FUNCTIONS.add(() -> new DateFieldGetter(DateFieldGetter.DateField.WEEK_DAY));
        CUSTOM_FUNCTIONS.add(() -> new DateFieldGetter(DateFieldGetter.DateField.DAY));
        CUSTOM_FUNCTIONS.add(() -> new DateFieldGetter(DateFieldGetter.DateField.HOUR));
        CUSTOM_FUNCTIONS.add(() -> new DateFieldGetter(DateFieldGetter.DateField.MINUTE));
        CUSTOM_FUNCTIONS.add(() -> new DateFieldGetter(DateFieldGetter.DateField.SECOND));
        CUSTOM_FUNCTIONS.add(() -> new DateFieldGetter(DateFieldGetter.DateField.MILLISECOND));
        CUSTOM_FUNCTIONS.add(JsonPath::new);
        CUSTOM_FUNCTIONS.add(XPath::new);
        CUSTOM_FUNCTIONS.add(Average::new);
        CUSTOM_FUNCTIONS.add(Count::new);
        CUSTOM_FUNCTIONS.add(Max::new);
        CUSTOM_FUNCTIONS.add(Min::new);
        CUSTOM_FUNCTIONS.add(UUID::new);
        CUSTOM_FUNCTIONS.add(Distinct::new);
        CUSTOM_FUNCTIONS.add(IsEmpty::new);
        CUSTOM_FUNCTIONS.add(ReadFile::new);
        CUSTOM_FUNCTIONS.add(TypeOf::new);
        CUSTOM_FUNCTIONS.add(() -> new UnaryBooleanFunction(UnaryBooleanFunction.Strategy.IS_DECIMAL));
        CUSTOM_FUNCTIONS.add(() -> new UnaryBooleanFunction(UnaryBooleanFunction.Strategy.IS_INTEGER));
        CUSTOM_FUNCTIONS.add(() -> new UnarySystemFunction(UnarySystemFunction.Strategy.GET_ENV));
        CUSTOM_FUNCTIONS.add(() -> new UnarySystemFunction(UnarySystemFunction.Strategy.GET_SYSTEM_PROPERTY));
        CUSTOM_FUNCTIONS.add(() -> new UnaryEncryptionFunction(UnaryEncryptionFunction.EncryptionAlgorithm.MD5));
        CUSTOM_FUNCTIONS.add(() -> new UnaryEncryptionFunction(UnaryEncryptionFunction.EncryptionAlgorithm.SHA1));
        CUSTOM_FUNCTIONS.add(() -> new UnaryEncryptionFunction(UnaryEncryptionFunction.EncryptionAlgorithm.SHA256));
        CUSTOM_FUNCTIONS.add(() -> new UnaryEncryptionFunction(UnaryEncryptionFunction.EncryptionAlgorithm.TO_BASE64));
        CUSTOM_FUNCTIONS.add(() -> new UnaryEncryptionFunction(UnaryEncryptionFunction.EncryptionAlgorithm.FROM_BASE64));
        CUSTOM_FUNCTIONS.add(BasicAuthorizationHeader::new);
        CUSTOM_FUNCTIONS.add(Http::new);
        CUSTOM_FUNCTIONS.add(HttpGet::new);
        CUSTOM_FUNCTIONS.add(HttpHeader::new);
        CUSTOM_FUNCTIONS.add(() -> new HttpResponseHandler(HttpResponseHandler.Strategy.GET_RESPONSE));
        CUSTOM_FUNCTIONS.add(() -> new HttpResponseHandler(HttpResponseHandler.Strategy.GET_STATUS_CODE));
        CUSTOM_FUNCTIONS.add(Arabic::new);
        CUSTOM_FUNCTIONS.add(Roman::new);
    }
}

