/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.jep.http;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.obvj.jep.http.WebServiceResponse;
import net.obvj.jep.util.EncryptionUtils;
import net.obvj.performetrics.Counter;
import net.obvj.performetrics.Stopwatch;
import org.apache.commons.lang3.StringUtils;

public class WebServiceUtils {
    private static Logger log = Logger.getLogger("jep-data-extension");
    private static final String BASIC_AUTHORIZATION_HEADER_PATTERN = "Basic %s";

    private WebServiceUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static String getAsString(String url) {
        return WebServiceUtils.getAsString(url, null);
    }

    public static String getAsString(String url, Map<String, String> headers) {
        WebServiceResponse response = WebServiceUtils.get(url, headers);
        return response.isSuccessful() ? response.getBody() : "";
    }

    public static String getResponseAsString(WebServiceResponse webServiceResponse) {
        return webServiceResponse.getBody();
    }

    public static WebServiceResponse get(String url) {
        return WebServiceUtils.get(url, null);
    }

    public static WebServiceResponse get(String url, Map<String, String> headers) {
        Client client = Client.create();
        WebResource webResource = client.resource(url);
        WebResource.Builder requestBuilder = webResource.getRequestBuilder();
        WebServiceUtils.copyHttpHeaders(requestBuilder, headers);
        log.log(Level.INFO, "Invoking GET on URL {0}", url);
        Stopwatch stopwatch = Stopwatch.createStarted((Counter.Type[])new Counter.Type[]{Counter.Type.WALL_CLOCK_TIME});
        ClientResponse response = (ClientResponse)requestBuilder.get(ClientResponse.class);
        stopwatch.stop();
        log.log(Level.INFO, "Operation finished in {0} seconds", stopwatch.elapsedTime(Counter.Type.WALL_CLOCK_TIME, TimeUnit.SECONDS));
        log.log(Level.INFO, "HTTP status code: {0} ({1})", new Object[]{response.getClientResponseStatus().getStatusCode(), response.getClientResponseStatus().getReasonPhrase()});
        log.log(Level.INFO, "HTTP response content type: {0}", response.getType());
        return WebServiceResponse.fromClientResponse(response);
    }

    public static WebServiceResponse invoke(String method, String url, Object requestEntity) {
        return WebServiceUtils.invoke(method, url, requestEntity, null);
    }

    public static WebServiceResponse invoke(String method, String url, Object requestEntity, Map<String, String> headers) {
        if (StringUtils.isEmpty((CharSequence)method)) {
            throw new IllegalArgumentException("The HTTP method cannot be empty");
        }
        String lMethod = method.toUpperCase();
        Client client = Client.create();
        WebResource webResource = client.resource(url);
        WebResource.Builder requestBuilder = webResource.getRequestBuilder();
        WebServiceUtils.copyHttpHeaders(requestBuilder, headers);
        log.log(Level.INFO, "Invoking {0} on URL {1}", new Object[]{lMethod, url});
        Stopwatch stopwatch = Stopwatch.createStarted((Counter.Type[])new Counter.Type[]{Counter.Type.WALL_CLOCK_TIME});
        ClientResponse response = (ClientResponse)requestBuilder.method(lMethod, ClientResponse.class, requestEntity);
        stopwatch.stop();
        log.log(Level.INFO, "Operation finished in {0} seconds", stopwatch.elapsedTime(Counter.Type.WALL_CLOCK_TIME, TimeUnit.SECONDS));
        log.log(Level.INFO, "HTTP status code: {0} ({1})", new Object[]{response.getClientResponseStatus().getStatusCode(), response.getClientResponseStatus().getReasonPhrase()});
        log.log(Level.INFO, "HTTP response content type: {0}", response.getType());
        return WebServiceResponse.fromClientResponse(response);
    }

    private static void copyHttpHeaders(WebResource.Builder requestBuilder, Map<String, String> headers) {
        if (headers != null) {
            log.log(Level.INFO, "HTTP headers: {0}", headers);
            headers.forEach((arg_0, arg_1) -> ((WebResource.Builder)requestBuilder).header(arg_0, arg_1));
        }
    }

    public static int getStatusCode(WebServiceResponse webServiceResponse) {
        return webServiceResponse.getStatusCode();
    }

    public static final String generateBasicAuthorizationHeader(String username, String password) {
        if (StringUtils.isEmpty((CharSequence)username)) {
            throw new IllegalArgumentException("Username cannot be empty");
        }
        if (StringUtils.isEmpty((CharSequence)password)) {
            throw new IllegalArgumentException("Password cannot be empty");
        }
        if (username.contains(":")) {
            throw new IllegalArgumentException("Username contains an invalid character (':')");
        }
        String encoding = EncryptionUtils.toBase64(username + ":" + password);
        return String.format(BASIC_AUTHORIZATION_HEADER_PATTERN, encoding);
    }
}

