/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.jep.functions;

import java.io.IOException;
import java.util.Stack;
import net.obvj.jep.functions.Function;
import net.obvj.jep.util.FileUtils;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

@Function(value={"readFile"})
public class ReadFile
extends PostfixMathCommand {
    private static final String UNABLE_TO_READ_FILE_MESSAGE = "Unable to read file '%s': Cause: %s";

    public ReadFile() {
        this.numberOfParameters = 1;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        String fileName = stack.pop().toString();
        try {
            stack.push(FileUtils.readFromFileSystem(fileName));
        }
        catch (IOException e) {
            throw new ParseException(String.format(UNABLE_TO_READ_FILE_MESSAGE, fileName, e.getClass().getName()));
        }
    }
}

