/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.jep.functions;

import java.util.Collection;
import java.util.Stack;
import net.obvj.jep.functions.Function;
import net.obvj.jep.util.CollectionsUtils;
import net.obvj.jep.util.JsonUtils;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

@Function(value={"isEmpty"})
public class IsEmpty
extends PostfixMathCommand {
    private static final double FALSE = 0.0;
    private static final double TRUE = 1.0;

    public IsEmpty() {
        this.numberOfParameters = 1;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object parameter = stack.pop();
        boolean isEmpty = this.isEmpty(parameter);
        stack.push(isEmpty ? 1.0 : 0.0);
    }

    private boolean isEmpty(Object object) {
        if (object instanceof String) {
            return this.validateStringWithJsonSupport((String)object);
        }
        if (object instanceof Collection) {
            return CollectionsUtils.isEmpty((Collection)object);
        }
        if (object instanceof JSONObject || object instanceof JSONArray) {
            return JsonUtils.isEmpty(object);
        }
        return object == null;
    }

    private boolean validateStringWithJsonSupport(String string) {
        try {
            JSONObject json = JsonUtils.convertToJSONObject(string);
            return JsonUtils.isEmpty((Object)json);
        }
        catch (JSONException e) {
            try {
                JSONArray json = JsonUtils.convertToJSONArray(string);
                return JsonUtils.isEmpty((Object)json);
            }
            catch (JSONException jSONException) {
                return StringUtils.isEmpty((CharSequence)string);
            }
        }
    }
}

