/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.jep.functions;

import java.util.Stack;
import net.obvj.jep.functions.MultiStrategyCommand;
import net.obvj.jep.util.EncryptionUtils;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class UnaryEncryptionFunction
extends PostfixMathCommand
implements MultiStrategyCommand {
    private final EncryptionAlgorithm encryptionAlgorithm;

    public UnaryEncryptionFunction(EncryptionAlgorithm encryptionAlgorithm) {
        this.numberOfParameters = 1;
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object arg1 = stack.pop();
        String sourceString = arg1.toString();
        String result = this.encryptionAlgorithm.execute(sourceString);
        stack.push(result);
    }

    @Override
    public Object getStrategy() {
        return this.encryptionAlgorithm;
    }

    public static enum EncryptionAlgorithm {
        MD5{

            @Override
            String execute(String content) {
                return EncryptionUtils.md5(content);
            }
        }
        ,
        SHA1{

            @Override
            String execute(String content) {
                return EncryptionUtils.sha1(content);
            }
        }
        ,
        SHA256{

            @Override
            String execute(String content) {
                return EncryptionUtils.sha256(content);
            }
        }
        ,
        TO_BASE64{

            @Override
            String execute(String content) {
                return EncryptionUtils.toBase64(content);
            }
        }
        ,
        FROM_BASE64{

            @Override
            String execute(String content) {
                return EncryptionUtils.fromBase64(content);
            }
        };


        abstract String execute(String var1);
    }
}

