/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.jep.functions;

import java.text.Normalizer;
import java.util.Stack;
import net.obvj.jep.functions.Function;
import org.apache.commons.lang3.StringUtils;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

@Function(value={"normalizeString"})
public class NormalizeString
extends PostfixMathCommand {
    public NormalizeString() {
        this.numberOfParameters = 1;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object argument = stack.pop();
        if (argument == null || StringUtils.isEmpty((CharSequence)argument.toString())) {
            stack.push(argument);
            return;
        }
        stack.push(NormalizeString.normalizeString(argument.toString()));
    }

    public static String normalizeString(String string) {
        string = Normalizer.normalize(string, Normalizer.Form.NFD);
        string = string.replaceAll("[^\\p{ASCII}]", "");
        return string;
    }
}

