/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.jep.functions;

import java.util.Stack;
import net.obvj.jep.functions.MultiStrategyCommand;
import net.obvj.jep.util.RegexUtils;
import org.apache.commons.lang3.StringUtils;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class BinaryBooleanFunction
extends PostfixMathCommand
implements MultiStrategyCommand {
    protected static final double FALSE = 0.0;
    protected static final double TRUE = 1.0;
    private final Strategy operation;

    public BinaryBooleanFunction(Strategy operation) {
        this.numberOfParameters = 2;
        this.operation = operation;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object arg2 = stack.pop();
        Object arg1 = stack.pop();
        boolean booleanValue = this.operation.evaluate(arg1, arg2);
        stack.push(booleanValue ? 1.0 : 0.0);
    }

    @Override
    public Object getStrategy() {
        return this.operation;
    }

    public static enum Strategy {
        STRING_STARTS_WITH{

            @Override
            boolean evaluate(Object arg1, Object arg2) {
                return StringUtils.startsWith((CharSequence)((String)arg1), (CharSequence)((String)arg2));
            }
        }
        ,
        STRING_ENDS_WITH{

            @Override
            boolean evaluate(Object arg1, Object arg2) {
                return StringUtils.endsWith((CharSequence)((String)arg1), (CharSequence)((String)arg2));
            }
        }
        ,
        STRING_MATCHES{

            @Override
            boolean evaluate(Object arg1, Object arg2) {
                if (arg2 == null) {
                    throw new IllegalArgumentException("The RegEx cannot be null");
                }
                return RegexUtils.matches((String)arg1, (String)arg2);
            }
        };


        abstract boolean evaluate(Object var1, Object var2);
    }
}

