/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.jep.util;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.obvj.performetrics.Counter;
import net.obvj.performetrics.Stopwatch;

public class FileUtils {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final Logger LOG = Logger.getLogger("jep-data-extension");

    private FileUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static String readFromClasspath(String fileName) throws IOException {
        URL url = FileUtils.class.getClassLoader().getResource(fileName);
        if (url == null) {
            throw new IllegalArgumentException("File not found in class path: " + fileName);
        }
        try {
            Path path = Paths.get(url.toURI());
            return FileUtils.readFromPath(path);
        }
        catch (URISyntaxException uriSyntaxException) {
            throw new IllegalArgumentException(uriSyntaxException);
        }
    }

    public static String readQuietlyFromClasspath(String fileName) {
        try {
            return FileUtils.readFromClasspath(fileName);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String readFromFileSystem(String path) throws IOException {
        return FileUtils.readFromPath(Paths.get(path, new String[0]));
    }

    protected static String readFromPath(Path path) throws IOException {
        LOG.log(Level.INFO, "Reading file: {0}", path);
        Stopwatch stopwatch = Stopwatch.createStarted((Counter.Type[])new Counter.Type[]{Counter.Type.WALL_CLOCK_TIME});
        try {
            String string = new String(Files.readAllBytes(path), DEFAULT_CHARSET);
            return string;
        }
        finally {
            LOG.log(Level.INFO, "Operation finished in {0} milliseconds", stopwatch.getCounter(Counter.Type.WALL_CLOCK_TIME).elapsedTime(TimeUnit.MILLISECONDS));
        }
    }
}

