/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.jep.functions;

import java.util.Stack;
import net.obvj.jep.functions.MultiStrategyCommand;
import net.obvj.jep.util.RegexUtils;
import org.apache.commons.lang3.StringUtils;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class Replace
extends PostfixMathCommand
implements MultiStrategyCommand {
    private final Strategy strategy;

    public Replace(Strategy searchStrategy) {
        this.numberOfParameters = 3;
        this.strategy = searchStrategy;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object arg3 = stack.pop();
        Object arg2 = stack.pop();
        Object arg1 = stack.pop();
        if (arg1 == null || arg2 == null) {
            stack.push(arg1);
            return;
        }
        String sourceString = arg1.toString();
        String searchString = arg2.toString();
        String replacement = arg3 == null ? "" : arg3.toString();
        String result = this.strategy.execute(sourceString, searchString, replacement);
        stack.push(result);
    }

    @Override
    public Object getStrategy() {
        return this.strategy;
    }

    public static enum Strategy {
        NORMAL{

            @Override
            String execute(String sourceString, String searchString, String replacement) {
                return StringUtils.replace((String)sourceString, (String)searchString, (String)replacement);
            }
        }
        ,
        REGEX{

            @Override
            String execute(String sourceString, String searchString, String replacement) {
                return RegexUtils.replaceMatches(sourceString, searchString, replacement);
            }
        };


        abstract String execute(String var1, String var2, String var3);
    }
}

