/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.jep.functions;

import java.util.Date;
import java.util.Stack;
import net.obvj.jep.functions.Function;
import net.obvj.jep.util.DateUtils;
import net.obvj.jep.util.NumberUtils;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

@Function(value={"isLeapYear"})
public class IsLeapYear
extends PostfixMathCommand {
    private static final double FALSE = 0.0;
    private static final double TRUE = 1.0;

    public IsLeapYear() {
        this.numberOfParameters = 1;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object parameter = stack.pop();
        boolean leapYear = false;
        if (NumberUtils.isNumber(parameter)) {
            int year = NumberUtils.parseInt(parameter);
            leapYear = DateUtils.isLeapYear(year);
        } else if (DateUtils.isParsable(parameter)) {
            Date date = DateUtils.parseDate(parameter);
            leapYear = DateUtils.isLeapYear(date);
        }
        stack.push(leapYear ? 1.0 : 0.0);
    }
}

