/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.confectory.helper;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JsonOrgJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JsonOrgMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.math.BigDecimal;
import java.util.Optional;
import java.util.function.Supplier;
import net.obvj.confectory.ConfigurationException;
import net.obvj.confectory.helper.AbstractBasicConfigurationHelper;
import net.obvj.confectory.helper.nullvalue.NullValueProvider;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONObjectHelper
extends AbstractBasicConfigurationHelper<JSONObject> {
    private final JSONObject jsonObject;
    private final JsonOrgMappingProvider mappingProvider;
    private final Configuration jsonPathConfiguration;
    private final ParseContext jsonPathContext;
    private final DocumentContext documentContext;

    public JSONObjectHelper(JSONObject jsonObject) {
        this.jsonObject = jsonObject;
        this.mappingProvider = new JsonOrgMappingProvider();
        this.jsonPathConfiguration = Configuration.builder().jsonProvider((JsonProvider)new JsonOrgJsonProvider()).mappingProvider((MappingProvider)this.mappingProvider).options(new Option[]{Option.SUPPRESS_EXCEPTIONS, Option.ALWAYS_RETURN_LIST}).build();
        this.jsonPathContext = JsonPath.using((Configuration)this.jsonPathConfiguration);
        this.documentContext = this.jsonPathContext.parse((Object)jsonObject);
    }

    public Optional<JSONObject> getBean() {
        return Optional.ofNullable(this.jsonObject);
    }

    public boolean getBoolean(String jsonPath) {
        return this.getValue(jsonPath, Boolean.TYPE, () -> ((NullValueProvider)this.nullValueProvider).getBooleanValue());
    }

    public int getInt(String jsonPath) {
        return this.getValue(jsonPath, Integer.TYPE, () -> ((NullValueProvider)this.nullValueProvider).getIntValue());
    }

    public long getLong(String jsonPath) {
        return this.getValue(jsonPath, Long.TYPE, () -> ((NullValueProvider)this.nullValueProvider).getLongValue());
    }

    public double getDouble(String jsonPath) {
        BigDecimal bigDecimal = this.getValue(jsonPath, BigDecimal.class, () -> BigDecimal.valueOf(this.nullValueProvider.getDoubleValue()));
        return bigDecimal.doubleValue();
    }

    public String getString(String jsonPath) {
        return this.getValue(jsonPath, String.class, () -> ((NullValueProvider)this.nullValueProvider).getStringValue());
    }

    private <T> T getValue(String jsonPath, Class<T> targetType, Supplier<T> defaultSupplier) {
        JSONArray result = (JSONArray)this.documentContext.read(jsonPath, new Predicate[0]);
        switch (result.length()) {
            case 0: {
                return defaultSupplier.get();
            }
            case 1: {
                return (T)this.mappingProvider.map(result.get(0), targetType, this.jsonPathConfiguration);
            }
        }
        throw new ConfigurationException("The specified JSONPath returned more than one element: %s", new Object[]{jsonPath});
    }
}

