/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.confectory.mapper;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import net.obvj.confectory.internal.helper.BeanConfigurationHelper;
import net.obvj.confectory.internal.helper.ConfigurationHelper;
import net.obvj.confectory.mapper.Mapper;

public class JacksonJsonToObjectMapper<T>
implements Mapper<T> {
    private static List<Module> cachedModules;
    protected Class<T> targetType;
    private boolean disableModules;

    public JacksonJsonToObjectMapper(Class<T> targetType) {
        this(targetType, false);
    }

    public JacksonJsonToObjectMapper(Class<T> targetType, boolean disableModules) {
        this.targetType = targetType;
        this.disableModules = disableModules;
    }

    public T apply(InputStream inputStream) throws IOException {
        return this.apply(inputStream, (ObjectMapper)new JsonMapper());
    }

    protected T apply(InputStream inputStream, ObjectMapper mapper) throws IOException {
        if (!this.disableModules) {
            mapper.registerModules(JacksonJsonToObjectMapper.reloadModulesIfNull());
        }
        return (T)mapper.readValue(inputStream, this.targetType);
    }

    private static List<Module> reloadModulesIfNull() {
        if (cachedModules == null) {
            JacksonJsonToObjectMapper.reloadModulesCache();
        }
        return cachedModules;
    }

    public static void reloadModulesCache() {
        cachedModules = Collections.unmodifiableList(ObjectMapper.findModules());
    }

    public static void resetModulesCache() {
        cachedModules = null;
    }

    static List<Module> getCachedModules() {
        return cachedModules;
    }

    public ConfigurationHelper<T> configurationHelper(T object) {
        return new BeanConfigurationHelper(object);
    }
}

