/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.confectory.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.obvj.confectory.util.JsonProvider;

public class JacksonJsonNodeJsonProvider
implements JsonProvider {
    private ObjectNode toJsonObject(Object jsonObject) {
        return (ObjectNode)jsonObject;
    }

    private ArrayNode toJsonArray(Object jsonArray) {
        return (ArrayNode)jsonArray;
    }

    public JsonNode toJsonNode(Object object) {
        return object instanceof JsonNode ? (JsonNode)object : (JsonNode)new ObjectMapper().convertValue(object, JsonNode.class);
    }

    public boolean isJsonObject(Object object) {
        return object instanceof ObjectNode;
    }

    public boolean isJsonArray(Object object) {
        return object instanceof ArrayNode;
    }

    public boolean isEmpty(Object jsonObject) {
        return this.toJsonObject(jsonObject).isEmpty();
    }

    public Object newJsonObject() {
        return JsonNodeFactory.instance.objectNode();
    }

    public Object newJsonObject(Object sourceJsonObject) {
        return JsonNodeFactory.instance.objectNode().setAll(this.toJsonObject(sourceJsonObject));
    }

    public Object newJsonArray() {
        return JsonNodeFactory.instance.arrayNode();
    }

    public Object newJsonArray(Object sourceJsonArray) {
        return JsonNodeFactory.instance.arrayNode().addAll(this.toJsonArray(sourceJsonArray));
    }

    public Set<Map.Entry<String, Object>> entrySet(Object jsonObject) {
        Iterator iterator = this.toJsonObject(jsonObject).fields();
        Iterable iterable = () -> iterator;
        return StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toSet());
    }

    public Object get(Object jsonObject, String key) {
        return this.toJsonObject(jsonObject).get(key);
    }

    public void put(Object jsonObject, String key, Object value) {
        this.toJsonObject(jsonObject).set(key, this.toJsonNode(value));
    }

    public void putIfAbsent(Object jsonObject, String key, Object value) {
        ObjectNode json = this.toJsonObject(jsonObject);
        if (json.get(key) == null) {
            json.set(key, this.toJsonNode(value));
        }
    }

    public void add(Object jsonArray, Object element) {
        this.toJsonArray(jsonArray).add(this.toJsonNode(element));
    }

    public void forEachElementInArray(Object jsonArray, Consumer<? super Object> action) {
        this.toJsonArray(jsonArray).forEach(action);
    }

    public boolean arrayContains(Object jsonArray, Object element) {
        return this.stream(jsonArray).anyMatch(element::equals);
    }

    public Stream<Object> stream(Object jsonArray) {
        Spliterator spliterator = this.toJsonArray(jsonArray).spliterator();
        return StreamSupport.stream(spliterator, false);
    }
}

