/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.confectory.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.obvj.confectory.util.JsonProvider;

public class GsonJsonProvider
implements JsonProvider {
    private final Gson gson = new Gson();

    private JsonObject toJsonObject(Object jsonObject) {
        return (JsonObject)jsonObject;
    }

    private JsonArray toJsonArray(Object jsonArray) {
        return (JsonArray)jsonArray;
    }

    protected JsonElement toJsonElement(Object object) {
        return object instanceof JsonElement ? (JsonElement)object : this.gson.toJsonTree(object);
    }

    public boolean isJsonObject(Object object) {
        return object instanceof JsonObject;
    }

    public boolean isJsonArray(Object object) {
        return object instanceof JsonArray;
    }

    public boolean isEmpty(Object jsonObject) {
        return this.toJsonObject(jsonObject).size() == 0;
    }

    public Object newJsonObject() {
        return new JsonObject();
    }

    public Object newJsonObject(Object sourceJsonObject) {
        JsonObject json = new JsonObject();
        this.toJsonObject(sourceJsonObject).entrySet().forEach(entry -> json.add((String)entry.getKey(), (JsonElement)entry.getValue()));
        return json;
    }

    public Object newJsonArray() {
        return new JsonArray();
    }

    public Object newJsonArray(Object sourceJsonArray) {
        JsonArray array = new JsonArray();
        array.addAll(this.toJsonArray(sourceJsonArray));
        return array;
    }

    public Set<Map.Entry<String, Object>> entrySet(Object jsonObject) {
        return this.toJsonObject(jsonObject).entrySet();
    }

    public Object get(Object jsonObject, String key) {
        return this.toJsonObject(jsonObject).get(key);
    }

    public void put(Object jsonObject, String key, Object value) {
        this.toJsonObject(jsonObject).add(key, this.toJsonElement(value));
    }

    public void putIfAbsent(Object jsonObject, String key, Object value) {
        JsonObject json = this.toJsonObject(jsonObject);
        if (json.get(key) == null) {
            json.add(key, this.toJsonElement(value));
        }
    }

    public void add(Object jsonArray, Object element) {
        this.toJsonArray(jsonArray).add(this.toJsonElement(element));
    }

    public void forEachElementInArray(Object jsonArray, Consumer<? super Object> action) {
        this.toJsonArray(jsonArray).forEach(action);
    }

    public boolean arrayContains(Object jsonArray, Object element) {
        return this.toJsonArray(jsonArray).contains(this.toJsonElement(element));
    }

    public Stream<Object> stream(Object jsonArray) {
        Spliterator spliterator = this.toJsonArray(jsonArray).spliterator();
        return StreamSupport.stream(spliterator, false);
    }
}

