/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.confectory.util;

import java.io.StringWriter;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.obvj.confectory.ConfigurationException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLUtils {
    private static final String YES = "yes";

    private XMLUtils() {
        throw new IllegalStateException("Instantiation not allowed");
    }

    public static DocumentBuilderFactory documentBuilderFactory() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        return factory;
    }

    public static TransformerFactory transformerFactory() {
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        return factory;
    }

    public static String toString(NodeList nodeList) {
        return IntStream.range(0, nodeList.getLength()).mapToObj(nodeList::item).map(XMLUtils::toString).collect(Collectors.joining("\n"));
    }

    public static String toString(Node node) {
        switch (node.getNodeType()) {
            case 2: 
            case 3: {
                return node.getTextContent();
            }
        }
        return XMLUtils.transformToString(node);
    }

    private static String transformToString(Node node) {
        DOMSource domSource = new DOMSource(node);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        try {
            Transformer transformer = XMLUtils.transformerFactory().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", YES);
            transformer.setOutputProperty("indent", YES);
            transformer.transform(domSource, result);
            return writer.toString().trim();
        }
        catch (TransformerException exception) {
            throw new ConfigurationException("Unable to convert document node into string", new Object[]{exception});
        }
    }
}

