/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.confectory.util;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Currency;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.function.Function;
import net.obvj.confectory.util.DateUtils;
import net.obvj.confectory.util.ParseException;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.function.Failable;

public class TypeFactory {
    private static final Map<Class<?>, Function<String, ?>> PARSERS = new HashMap();

    private TypeFactory() {
        throw new UnsupportedOperationException("Instantiation not allowed");
    }

    public static <T> T parse(Class<T> type, String string) throws ParseException {
        if (type.isEnum()) {
            return TypeFactory.getEnumElement(type, string);
        }
        Class objectType = ClassUtils.primitiveToWrapper(type);
        Function<String, ?> parser = TypeFactory.getParser(objectType);
        try {
            Object object = parser.apply(string);
            return (T)object;
        }
        catch (Exception exception) {
            throw new ParseException(exception, "Unparsable %s: \"%s\"", type.getCanonicalName(), string);
        }
    }

    private static <T> T getEnumElement(Class<T> type, String string) {
        return (T)EnumUtils.getEnumIgnoreCase(type, (String)string);
    }

    private static Function<String, ?> getParser(Class<?> type) {
        Function<String, ?> parser = PARSERS.get(type);
        if (parser == null) {
            throw new UnsupportedOperationException("Unsupported type: " + type);
        }
        return parser;
    }

    static {
        PARSERS.put(Boolean.class, Boolean::valueOf);
        PARSERS.put(Byte.class, Byte::valueOf);
        PARSERS.put(Short.class, Short::valueOf);
        PARSERS.put(Integer.class, Integer::valueOf);
        PARSERS.put(Long.class, Long::valueOf);
        PARSERS.put(Float.class, Float::valueOf);
        PARSERS.put(Double.class, Double::valueOf);
        PARSERS.put(Character.class, string -> Character.valueOf(string.isEmpty() ? (char)'\u0000' : Character.valueOf(string.charAt(0)).charValue()));
        PARSERS.put(String.class, Function.identity());
        PARSERS.put(Class.class, Failable.asFunction(Class::forName));
        PARSERS.put(LocalDate.class, LocalDate::parse);
        PARSERS.put(LocalTime.class, LocalTime::parse);
        PARSERS.put(LocalDateTime.class, LocalDateTime::parse);
        PARSERS.put(OffsetDateTime.class, OffsetDateTime::parse);
        PARSERS.put(OffsetTime.class, OffsetTime::parse);
        PARSERS.put(ZonedDateTime.class, ZonedDateTime::parse);
        PARSERS.put(ZoneId.class, ZoneId::of);
        PARSERS.put(ZoneOffset.class, ZoneOffset::of);
        PARSERS.put(Instant.class, Instant::parse);
        PARSERS.put(Duration.class, Duration::parse);
        PARSERS.put(Date.class, Date::valueOf);
        PARSERS.put(Time.class, Time::valueOf);
        PARSERS.put(Timestamp.class, Timestamp::valueOf);
        PARSERS.put(BigInteger.class, BigInteger::new);
        PARSERS.put(BigDecimal.class, BigDecimal::new);
        PARSERS.put(Currency.class, Currency::getInstance);
        PARSERS.put(java.util.Date.class, DateUtils::parseDateRfc3339);
        PARSERS.put(TimeZone.class, TimeZone::getTimeZone);
        PARSERS.put(UUID.class, UUID::fromString);
        PARSERS.put(InetAddress.class, Failable.asFunction(InetAddress::getByName));
        PARSERS.put(URI.class, Failable.asFunction(URI::new));
        PARSERS.put(URL.class, Failable.asFunction(URL::new));
        PARSERS.put(File.class, File::new);
        PARSERS.put(Charset.class, Charset::forName);
        PARSERS.put(Path.class, x$0 -> Paths.get(x$0, new String[0]));
    }
}

