/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.confectory.util;

import java.lang.reflect.Field;
import java.util.Optional;
import net.obvj.confectory.util.ObjectFactory;
import net.obvj.confectory.util.ParseException;
import net.obvj.confectory.util.Property;
import net.obvj.confectory.util.StringUtils;
import net.obvj.confectory.util.TypeConverter;
import net.obvj.confectory.util.TypeFactory;
import org.apache.commons.lang3.reflect.FieldUtils;

public class PropertyUtils {
    private PropertyUtils() {
        throw new UnsupportedOperationException("Instantiation not allowed");
    }

    public static String getPropertyKeyOrFieldName(Property property, Field field) {
        return StringUtils.defaultIfEmpty(PropertyUtils.getPropertyKey(property), field::getName);
    }

    public static String getPropertyKey(Property property) {
        return property != null ? (String)org.apache.commons.lang3.StringUtils.defaultIfEmpty((CharSequence)property.value(), (CharSequence)property.key()) : "";
    }

    public static Field findFieldByPropertyKeyOrName(Class<?> type, String name) {
        return PropertyUtils.findFieldByPropertyKey(type, name).orElseGet(() -> FieldUtils.getField((Class)type, (String)name, (boolean)true));
    }

    public static Optional<Field> findFieldByPropertyKey(Class<?> type, String name) {
        return FieldUtils.getFieldsListWithAnnotation(type, Property.class).stream().filter(field -> PropertyUtils.isFieldAnnotated(field, name)).findAny();
    }

    public static boolean isFieldAnnotated(Field field, String name) {
        Property property = field.getDeclaredAnnotation(Property.class);
        return PropertyUtils.getPropertyKey(property).equals(name);
    }

    public static Object parseValue(String string, Field field, ObjectFactory objectFactory) throws ReflectiveOperationException, ParseException {
        return PropertyUtils.parseValue(string, field.getType(), field.getAnnotation(Property.class), objectFactory);
    }

    public static Object parseValue(String string, Class<?> targetType, Property property, ObjectFactory objectFactory) throws ReflectiveOperationException, ParseException {
        if (property != null && property.converter().length > 0) {
            TypeConverter<?> converter = objectFactory.newObject(property.converter()[0]);
            return converter.convert(string);
        }
        return TypeFactory.parse(targetType, string);
    }
}

