/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.confectory.settings;

import java.util.Objects;
import net.obvj.confectory.DataFetchStrategy;
import net.obvj.confectory.util.ObjectFactory;

public class ConfectorySettings {
    static final DataFetchStrategy INITIAL_DATA_FETCH_STRATEGY = DataFetchStrategy.LENIENT;
    static final ObjectFactory INITIAL_OBJECT_FACTORY = ObjectFactory.FAST;
    private static final ConfectorySettings INSTANCE = new ConfectorySettings();
    private DataFetchStrategy defaultDataFetchStrategy;
    private ObjectFactory objectFactory;

    private ConfectorySettings() {
        this.reset();
    }

    public void reset() {
        this.defaultDataFetchStrategy = INITIAL_DATA_FETCH_STRATEGY;
        this.objectFactory = INITIAL_OBJECT_FACTORY;
    }

    public static ConfectorySettings instance() {
        return INSTANCE;
    }

    public DataFetchStrategy getDataFetchStrategy() {
        return this.defaultDataFetchStrategy;
    }

    public void setDataFetchStrategy(DataFetchStrategy strategy) {
        this.defaultDataFetchStrategy = Objects.requireNonNull(strategy, "the default DataFetchStrategy must not be null");
    }

    public ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = Objects.requireNonNull(objectFactory, "the ObjectFactory must not be null");
    }
}

