/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.confectory.merger;

import java.util.Properties;
import java.util.function.BiConsumer;
import net.obvj.confectory.Configuration;
import net.obvj.confectory.merger.AbstractConfigurationMerger;
import net.obvj.jsonmerge.JsonMergeOption;

public class PropertiesConfigurationMerger
extends AbstractConfigurationMerger<Properties> {
    @Override
    Properties doMerge(Configuration<Properties> config1, Configuration<Properties> config2, JsonMergeOption ... mergeOptions) {
        Properties properties1 = this.getPropertiesSafely(config1);
        Properties properties2 = this.getPropertiesSafely(config2);
        if (properties1.isEmpty()) {
            return properties2;
        }
        if (properties2.isEmpty()) {
            return properties1;
        }
        Properties result = new Properties();
        properties1.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            Object actualValue = properties2.containsKey(key) && config2.getPrecedence() > config1.getPrecedence() ? properties2.get(key) : value;
            result.put(key, actualValue);
        }));
        properties2.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)result::putIfAbsent));
        return result;
    }

    private Properties getPropertiesSafely(Configuration<Properties> config) {
        return this.getBeanSafely(config, Properties::new);
    }
}

