/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.confectory.mapper;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.Properties;
import net.obvj.confectory.ConfigurationException;
import net.obvj.confectory.internal.helper.BeanConfigurationHelper;
import net.obvj.confectory.internal.helper.ConfigurationHelper;
import net.obvj.confectory.mapper.Mapper;
import net.obvj.confectory.mapper.PropertiesMapper;
import net.obvj.confectory.settings.ConfectorySettings;
import net.obvj.confectory.util.ObjectFactory;
import net.obvj.confectory.util.ParseException;
import net.obvj.confectory.util.Property;
import net.obvj.confectory.util.PropertyUtils;
import net.obvj.confectory.util.ReflectionUtils;
import org.apache.commons.lang3.reflect.FieldUtils;

public class PropertiesToObjectMapper<T>
implements Mapper<T> {
    private static final String MSG_UNABLE_TO_PARSE_PROPERTY = "Unable to parse the value of the property '%s' into a field of type '%s'";
    private final Class<T> targetType;
    private final ObjectFactory objectFactory;

    public PropertiesToObjectMapper(Class<T> targetType) {
        this(targetType, ConfectorySettings.instance().getObjectFactory());
    }

    public PropertiesToObjectMapper(Class<T> targetType, ObjectFactory objectFactory) {
        this.targetType = targetType;
        this.objectFactory = Objects.requireNonNull(objectFactory, "the ObjectFactory must not be null");
    }

    @Override
    public T apply(InputStream inputStream) throws IOException {
        Properties properties = new PropertiesMapper().apply(inputStream);
        return this.asObject(properties);
    }

    private T asObject(Properties properties) {
        Field[] fields = FieldUtils.getAllFields(this.targetType);
        try {
            T targetObject = this.objectFactory.newObject(this.targetType);
            for (Field field : fields) {
                this.writeField(targetObject, field, properties);
            }
            return targetObject;
        }
        catch (ReflectiveOperationException exception) {
            throw new ConfigurationException(exception, "Unable to build object of type: %s", this.targetType);
        }
    }

    private void writeField(T targetObject, Field field, Properties properties) throws ReflectiveOperationException {
        if (ReflectionUtils.isTransient(field)) {
            return;
        }
        Property annotation = PropertiesToObjectMapper.getPropertyAnnotation(field);
        String propertyKey = PropertyUtils.getPropertyKeyOrFieldName(annotation, field);
        String propertyValue = properties.getProperty(propertyKey);
        if (propertyValue != null) {
            Class<?> fieldType = field.getType();
            try {
                Object parsedValue = PropertyUtils.parseValue(propertyValue, fieldType, annotation, this.objectFactory);
                FieldUtils.writeDeclaredField(targetObject, (String)field.getName(), (Object)parsedValue, (boolean)true);
            }
            catch (ParseException exception) {
                throw new ConfigurationException(exception, MSG_UNABLE_TO_PARSE_PROPERTY, propertyKey, fieldType.getCanonicalName());
            }
        }
    }

    private static Property getPropertyAnnotation(Field field) {
        return field.getDeclaredAnnotation(Property.class);
    }

    @Override
    public ConfigurationHelper<T> configurationHelper(T type) {
        return new BeanConfigurationHelper<T>(type);
    }
}

