/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.confectory.mapper;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Objects;
import net.obvj.confectory.ConfigurationException;
import net.obvj.confectory.internal.helper.BeanConfigurationHelper;
import net.obvj.confectory.internal.helper.ConfigurationHelper;
import net.obvj.confectory.mapper.AbstractINIMapper;
import net.obvj.confectory.mapper.Mapper;
import net.obvj.confectory.settings.ConfectorySettings;
import net.obvj.confectory.util.ObjectFactory;
import net.obvj.confectory.util.ParseException;
import net.obvj.confectory.util.PropertyUtils;
import net.obvj.confectory.util.ReflectionUtils;
import org.apache.commons.lang3.reflect.FieldUtils;

public class INIToObjectMapper<T>
extends AbstractINIMapper<T>
implements Mapper<T> {
    private static final String DELIMITER_LEFT = "['";
    private static final String DELIMITER_RIGHT = "']";
    private static final String MSG_UNABLE_TO_BUILD_OBJECT = "Unable to build object of type: %s";
    private static final String MSG_UNPARSABLE_PROPERTY_VALUE = "Unable to parse the value of the property %s into a field of type '%s'";
    private final Class<T> targetType;
    private final ObjectFactory objectFactory;

    public INIToObjectMapper(Class<T> targetType) {
        this(targetType, ConfectorySettings.instance().getObjectFactory());
    }

    public INIToObjectMapper(Class<T> targetType, ObjectFactory objectFactory) {
        this.targetType = targetType;
        this.objectFactory = Objects.requireNonNull(objectFactory, "the ObjectFactory must not be null");
    }

    @Override
    public T apply(InputStream inputStream) throws IOException {
        return (T)this.doApply(inputStream);
    }

    @Override
    Object newObject(AbstractINIMapper.Context context) {
        Class<?> type = this.getCurrentType(context);
        try {
            return type != null ? this.objectFactory.newObject(type) : null;
        }
        catch (ReflectiveOperationException exception) {
            throw new ConfigurationException(exception, MSG_UNABLE_TO_BUILD_OBJECT, type);
        }
    }

    @Override
    Object parseValue(AbstractINIMapper.Context context, String value) {
        Class<?> currentType = this.getCurrentType(context);
        Field field = PropertyUtils.findFieldByPropertyKeyOrName(currentType, context.currentKey);
        try {
            return field != null ? PropertyUtils.parseValue(value, field, this.objectFactory) : null;
        }
        catch (ReflectiveOperationException | ParseException exception) {
            throw new ConfigurationException(exception, MSG_UNPARSABLE_PROPERTY_VALUE, this.currentFieldIdentifierToString(context), field.getType().getCanonicalName());
        }
    }

    @Override
    void put(Object target, String name, Object value) {
        Field field = PropertyUtils.findFieldByPropertyKeyOrName(target.getClass(), name);
        if (field != null && !ReflectionUtils.isTransient(field)) {
            try {
                FieldUtils.writeDeclaredField((Object)target, (String)field.getName(), (Object)value, (boolean)true);
            }
            catch (IllegalAccessException exception) {
                throw new ConfigurationException(exception, MSG_UNABLE_TO_BUILD_OBJECT, target);
            }
        }
    }

    private Class<?> getCurrentType(AbstractINIMapper.Context context) {
        if (context.currentSectionName == null) {
            return this.targetType;
        }
        Field field = PropertyUtils.findFieldByPropertyKeyOrName(this.targetType, context.currentSectionName);
        return field != null ? field.getType() : null;
    }

    private String currentFieldIdentifierToString(AbstractINIMapper.Context context) {
        StringBuilder builder = new StringBuilder();
        if (context.currentSectionName != null) {
            builder.append(DELIMITER_LEFT).append(context.currentSectionName).append(DELIMITER_RIGHT);
        }
        builder.append(DELIMITER_LEFT).append(context.currentKey).append(DELIMITER_RIGHT);
        return builder.toString();
    }

    @Override
    public ConfigurationHelper<T> configurationHelper(T object) {
        return new BeanConfigurationHelper<T>(object);
    }
}

