/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.confectory.mapper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import net.obvj.confectory.ConfigurationSourceException;
import net.obvj.confectory.mapper.Mapper;

public abstract class AbstractINIMapper<T>
implements Mapper<T> {
    private static final char TOKEN_COMMENT_START = ';';
    private static final char TOKEN_COMMENT_START_ALT = '#';
    private static final char TOKEN_SECTION_NAME_START = '[';
    private static final char TOKEN_SECTION_NAME_END = ']';
    private static final String TOKEN_KEY_VALUE_DELIMITER = "=";
    private static final String MSG_MALFORMED_INI = "Malformed INI: expected %s at line %s: \"%s\"";
    private static final String ARG_SECTION_NAME = "section name";
    private static final String ARG_PROPERTY_KEY = "property key";
    private static final String ARG_PROPERTY = "property";
    private static final String ARG_TOKEN = "token '%s'";

    final Object doApply(InputStream inputStream) throws IOException {
        Object out;
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        Context context = new Context();
        context.currentLine = reader.readLine();
        context.currentLineNumber = 1;
        context.currentSectionName = null;
        Object currentSection = out = this.newObject(context);
        boolean skipSection = false;
        while (context.currentLine != null) {
            context.currentLine = context.currentLine.trim();
            if (!context.currentLine.isEmpty() && !AbstractINIMapper.isCommentLine(context.currentLine)) {
                if (AbstractINIMapper.isSectionLine(context.currentLine)) {
                    skipSection = false;
                    context.currentSectionName = AbstractINIMapper.parseSectionName(context);
                    currentSection = this.newObject(context);
                    if (currentSection == null) {
                        skipSection = true;
                    } else {
                        this.put(out, context.currentSectionName, currentSection);
                    }
                } else if (AbstractINIMapper.isPropertyLine(context.currentLine)) {
                    if (!skipSection) {
                        context.currentKey = AbstractINIMapper.parseKey(context);
                        Object value = this.parseValue(context);
                        this.put(currentSection, context.currentKey, value);
                    }
                } else {
                    throw AbstractINIMapper.malformedIniException(context, ARG_PROPERTY);
                }
            }
            context.currentLine = reader.readLine();
            ++context.currentLineNumber;
        }
        return out;
    }

    private static final boolean isCommentLine(String line) {
        char firstCharacter = line.charAt(0);
        return firstCharacter == ';' || firstCharacter == '#';
    }

    private static final boolean isSectionLine(String line) {
        return line.charAt(0) == '[';
    }

    private static final String parseSectionName(Context context) {
        int sectionNameDelimiterIndex = context.currentLine.indexOf(93);
        if (sectionNameDelimiterIndex < 0) {
            throw AbstractINIMapper.malformedIniException(context, String.format(ARG_TOKEN, Character.valueOf(']')));
        }
        String name = context.currentLine.substring(1, sectionNameDelimiterIndex);
        if (name.isEmpty()) {
            throw AbstractINIMapper.malformedIniException(context, ARG_SECTION_NAME);
        }
        return name;
    }

    private static final boolean isPropertyLine(String line) {
        return line.contains(TOKEN_KEY_VALUE_DELIMITER);
    }

    private static final String parseKey(Context context) {
        int endIndex = context.currentLine.indexOf(TOKEN_KEY_VALUE_DELIMITER);
        String key = context.currentLine.substring(0, endIndex).trim();
        if (key.isEmpty()) {
            throw AbstractINIMapper.malformedIniException(context, ARG_PROPERTY_KEY);
        }
        return key;
    }

    private final Object parseValue(Context context) {
        int beginIndex = context.currentLine.indexOf(TOKEN_KEY_VALUE_DELIMITER) + 1;
        String value = context.currentLine.substring(beginIndex).trim();
        return this.parseValue(context, value);
    }

    private static final ConfigurationSourceException malformedIniException(Context context, String expected) {
        return new ConfigurationSourceException(MSG_MALFORMED_INI, expected, context.currentLineNumber, context.currentLine);
    }

    abstract Object newObject(Context var1);

    abstract Object parseValue(Context var1, String var2);

    abstract void put(Object var1, String var2, Object var3);

    static class Context {
        String currentLine;
        String currentSectionName;
        String currentKey;
        int currentLineNumber;

        Context() {
        }
    }
}

