/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.confectory.internal.helper;

import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import net.obvj.confectory.ConfigurationException;
import net.obvj.confectory.internal.helper.BasicConfigurationHelper;
import net.obvj.confectory.merger.ConfigurationMerger;
import net.obvj.confectory.merger.PropertiesConfigurationMerger;

public class PropertiesConfigurationHelper
extends BasicConfigurationHelper<Properties> {
    public PropertiesConfigurationHelper(Properties properties) {
        super(properties);
    }

    @Override
    public String getAsString() {
        return ((Properties)this.bean).entrySet().stream().map(Object::toString).collect(Collectors.joining("\n"));
    }

    @Override
    public Object get(String key) {
        this.validateKey(key);
        return ((Properties)this.bean).get(key);
    }

    @Override
    public String getString(String key) {
        return this.getValue(key);
    }

    @Override
    public String getMandatoryString(String key) {
        String value = this.getValue(key);
        if (value == null) {
            throw new ConfigurationException("No value found for the key: %s", key);
        }
        return value;
    }

    protected String getValue(String key) {
        this.validateKey(key);
        return ((Properties)this.bean).getProperty(key);
    }

    private void validateKey(String key) {
        Objects.requireNonNull(key, "The key must not be null");
    }

    @Override
    public ConfigurationMerger<Properties> configurationMerger() {
        return new PropertiesConfigurationMerger();
    }
}

