/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.confectory;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import net.obvj.confectory.Configuration;
import net.obvj.confectory.util.ConfigurationComparator;
import org.apache.commons.lang3.StringUtils;

public enum DataFetchStrategy {
    STRICT{

        @Override
        Stream<Configuration<?>> getConfigurationStream(String namespace, Map<String, Set<Configuration<?>>> configMap) {
            return STRICT_UNSORTED.getConfigurationStream(namespace, configMap).sorted(new ConfigurationComparator());
        }
    }
    ,
    STRICT_UNSORTED{

        @Override
        Stream<Configuration<?>> getConfigurationStream(String namespace, Map<String, Set<Configuration<?>>> configMap) {
            return configMap.getOrDefault(DataFetchStrategy.parseNamespace(namespace), Collections.emptySet()).stream();
        }
    }
    ,
    LENIENT{

        @Override
        Stream<Configuration<?>> getConfigurationStream(String namespace, Map<String, Set<Configuration<?>>> configMap) {
            if (StringUtils.isEmpty((CharSequence)namespace)) {
                return LENIENT_UNSORTED.getConfigurationStream(namespace, configMap).sorted(new ConfigurationComparator());
            }
            return STRICT.getConfigurationStream(namespace, configMap);
        }
    }
    ,
    LENIENT_UNSORTED{

        @Override
        Stream<Configuration<?>> getConfigurationStream(String namespace, Map<String, Set<Configuration<?>>> configMap) {
            if (StringUtils.isEmpty((CharSequence)namespace)) {
                return configMap.values().stream().flatMap(Collection::stream);
            }
            return STRICT_UNSORTED.getConfigurationStream(namespace, configMap);
        }
    };


    abstract Stream<Configuration<?>> getConfigurationStream(String var1, Map<String, Set<Configuration<?>>> var2);

    private static String parseNamespace(String namespace) {
        return Objects.toString(namespace, "");
    }
}

