/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.confectory.source;

import java.io.FileNotFoundException;
import java.net.URL;
import net.obvj.confectory.ConfigurationSourceException;
import net.obvj.confectory.mapper.Mapper;
import net.obvj.confectory.source.Source;
import net.obvj.confectory.source.URLSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathFileSource<T>
extends URLSource<T>
implements Source<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClasspathFileSource.class);

    public ClasspathFileSource(String path) {
        super(path);
    }

    @Override
    public T load(Mapper<T> mapper) {
        URL url = ClasspathFileSource.classpathResourceToURL(this.parameter);
        return super.load(url, mapper);
    }

    private static URL classpathResourceToURL(String resource) {
        LOGGER.info("Searching classpath resource: {}", (Object)resource);
        URL url = ClasspathFileSource.class.getClassLoader().getResource(resource);
        if (url == null) {
            String message = String.format("Classpath resource not found: %s", resource);
            LOGGER.warn(message);
            throw new ConfigurationSourceException(new FileNotFoundException(message));
        }
        LOGGER.debug("Classpath resource found: \"{}\"", (Object)url.getPath());
        return url;
    }
}

