/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.confectory.merger;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.obvj.confectory.Configuration;
import net.obvj.confectory.merger.AbstractConfigurationMerger;
import net.obvj.confectory.util.ConfigurationComparator;
import net.obvj.jsonmerge.JsonMergeOption;
import net.obvj.jsonmerge.JsonMerger;
import net.obvj.jsonmerge.provider.JsonProvider;

public class GenericJsonConfigurationMerger<T>
extends AbstractConfigurationMerger<T> {
    private final JsonProvider<T> jsonProvider;

    public GenericJsonConfigurationMerger(JsonProvider<T> jsonProvider) {
        this.jsonProvider = Objects.requireNonNull(jsonProvider, "The JsonProvider cannot be null");
    }

    @Override
    T doMerge(Configuration<T> config1, Configuration<T> config2, JsonMergeOption ... mergeOptions) {
        List<T> jsonObjects = this.sortJsonObjects(config1, config2);
        JsonMerger merger = new JsonMerger(this.jsonProvider);
        return (T)merger.merge(jsonObjects.get(0), jsonObjects.get(1), mergeOptions);
    }

    private List<T> sortJsonObjects(Configuration<T> config1, Configuration<T> config2) {
        return Arrays.asList(config1, config2).stream().sorted(new ConfigurationComparator()).map(this::getJsonObjectSafely).collect(Collectors.toList());
    }

    private T getJsonObjectSafely(Configuration<T> config) {
        return (T)this.getBeanSafely(config, () -> this.jsonProvider.newJsonObject());
    }
}

