/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.confectory.internal.helper;

import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.obvj.confectory.ConfigurationException;
import net.obvj.confectory.internal.helper.ConfigurationHelper;
import net.obvj.confectory.merger.ConfigurationMerger;
import net.obvj.confectory.util.ParseFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DocumentConfigurationHelper
implements ConfigurationHelper<Document> {
    protected final Document document;

    public DocumentConfigurationHelper(Document document) {
        this.document = document;
    }

    @Override
    public Document getBean() {
        return this.document;
    }

    @Override
    public Boolean getBoolean(String xpath) {
        return this.getValue(xpath, Boolean.class, false);
    }

    @Override
    public Boolean getMandatoryBoolean(String xpath) {
        return this.getValue(xpath, Boolean.class);
    }

    @Override
    public Integer getInteger(String xpath) {
        return this.getValue(xpath, Integer.class, false);
    }

    @Override
    public Integer getMandatoryInteger(String xpath) {
        return this.getValue(xpath, Integer.class);
    }

    @Override
    public Long getLong(String xpath) {
        return this.getValue(xpath, Long.class, false);
    }

    @Override
    public Long getMandatoryLong(String xpath) {
        return this.getValue(xpath, Long.class);
    }

    @Override
    public Double getDouble(String xpath) {
        return this.getValue(xpath, Double.class, false);
    }

    @Override
    public Double getMandatoryDouble(String xpath) {
        return this.getValue(xpath, Double.class);
    }

    @Override
    public String getString(String xpath) {
        return this.getValue(xpath, String.class, false);
    }

    @Override
    public String getMandatoryString(String xpath) {
        return this.getValue(xpath, String.class);
    }

    protected <T> T getValue(String xpath, Class<T> targetType) {
        return this.getValue(xpath, targetType, true);
    }

    protected <T> T getValue(String xpath, Class<T> targetType, boolean mandatory) {
        NodeList result = this.get(xpath);
        switch (result.getLength()) {
            case 0: {
                if (mandatory) {
                    throw new ConfigurationException("No value found for path: %s", xpath);
                }
                return null;
            }
            case 1: {
                Node node = result.item(0);
                return ParseFactory.parse(targetType, node.getTextContent());
            }
        }
        throw new ConfigurationException("Multiple values found for path: %s", xpath);
    }

    @Override
    public NodeList get(String xpath) {
        try {
            return (NodeList)DocumentConfigurationHelper.compileXPath(xpath).evaluate(this.document, XPathConstants.NODESET);
        }
        catch (XPathExpressionException exception) {
            throw new ConfigurationException(exception);
        }
    }

    public static XPathExpression compileXPath(String expression) throws XPathExpressionException {
        return XPathFactory.newInstance().newXPath().compile(expression);
    }

    @Override
    public ConfigurationMerger<Document> configurationMerger() {
        throw new UnsupportedOperationException("Merge not supported for XML");
    }
}

