/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.confectory;

import net.obvj.confectory.ConfigurationDataRetriever;
import net.obvj.confectory.internal.helper.ConfigurationHelper;
import net.obvj.confectory.mapper.Mapper;
import net.obvj.confectory.source.Source;

final class ConfigurationService<T>
implements ConfigurationDataRetriever<T> {
    private final T bean;
    private final ConfigurationHelper<T> helper;

    ConfigurationService(Source<T> source, Mapper<T> mapper, boolean optional) {
        this(source.load(mapper, optional), mapper);
    }

    ConfigurationService(T bean, Mapper<T> mapper) {
        this.bean = bean;
        this.helper = ConfigurationHelper.newInstance(bean, mapper);
    }

    ConfigurationHelper<T> getHelper() {
        return this.helper;
    }

    @Override
    public T getBean() {
        return this.bean;
    }

    @Override
    public Object get(String key) {
        return this.helper.get(key);
    }

    @Override
    public Boolean getBoolean(String key) {
        return this.helper.getBoolean(key);
    }

    @Override
    public Integer getInteger(String key) {
        return this.helper.getInteger(key);
    }

    @Override
    public Long getLong(String key) {
        return this.helper.getLong(key);
    }

    @Override
    public Double getDouble(String key) {
        return this.helper.getDouble(key);
    }

    @Override
    public String getString(String key) {
        return this.helper.getString(key);
    }

    @Override
    public Boolean getMandatoryBoolean(String key) {
        return this.helper.getMandatoryBoolean(key);
    }

    @Override
    public Integer getMandatoryInteger(String key) {
        return this.helper.getMandatoryInteger(key);
    }

    @Override
    public Long getMandatoryLong(String key) {
        return this.helper.getMandatoryLong(key);
    }

    @Override
    public Double getMandatoryDouble(String key) {
        return this.helper.getMandatoryDouble(key);
    }

    @Override
    public String getMandatoryString(String key) {
        return this.helper.getMandatoryString(key);
    }
}

